Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.15/_createPadding', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    import baseRepeat from './_baseRepeat.js';
    import baseToString from './_baseToString.js';
    import castSlice from './_castSlice.js';
    import hasUnicode from './_hasUnicode.js';
    import stringSize from './_stringSize.js';
    import stringToArray from './_stringToArray.js';

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeCeil = Math.ceil;

    /**
     * Creates the padding for `string` based on `length`. The `chars` string
     * is truncated if the number of characters exceeds `length`.
     *
     * @private
     * @param {number} length The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padding for `string`.
     */
    function createPadding(length, chars) {
      chars = chars === undefined ? ' ' : baseToString(chars);

      var charsLength = chars.length;
      if (charsLength < 2) {
        return charsLength ? baseRepeat(chars, length) : chars;
      }
      var result = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
      return hasUnicode(chars) ? castSlice(stringToArray(result), 0, length).join('') : result.slice(0, length);
    }

    export default createPadding;
  }
});
//# sourceMappingURL=_createPadding.js.map