Liferay.Loader.define('frontend-js-tooltip-support-web$lodash-es@4.17.15/_cloneSet', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import addSetEntry from './_addSetEntry.js';
  import arrayReduce from './_arrayReduce.js';
  import setToArray from './_setToArray.js';

  /** Used to compose bitmasks for cloning. */
  var CLONE_DEEP_FLAG = 1;

  /**
   * Creates a clone of `set`.
   *
   * @private
   * @param {Object} set The set to clone.
   * @param {Function} cloneFunc The function to clone values.
   * @param {boolean} [isDeep] Specify a deep clone.
   * @returns {Object} Returns the cloned set.
   */
  function cloneSet(set, isDeep, cloneFunc) {
    var array = isDeep ? cloneFunc(setToArray(set), CLONE_DEEP_FLAG) : setToArray(set);
    return arrayReduce(array, addSetEntry, new set.constructor());
  }

  export default cloneSet;
});
//# sourceMappingURL=_cloneSet.js.map