/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @typechecks
 */

'use strict';

Liferay.Loader.define('frontend-js-tooltip-support-web$fbjs@0.8.17/lib/getScrollPosition', ['module', 'exports', 'require', './getDocumentScrollElement', './getUnboundedScrollPosition'], function (module, exports, require) {
  var define = undefined;
  var getDocumentScrollElement = require('./getDocumentScrollElement');
  var getUnboundedScrollPosition = require('./getUnboundedScrollPosition');

  /**
   * Gets the scroll position of the supplied element or window.
   *
   * The return values are bounded. This means that if the scroll position is
   * negative or exceeds the element boundaries (which is possible using inertial
   * scrolling), you will get zero or the maximum scroll position, respectively.
   *
   * If you need the unbound scroll position, use `getUnboundedScrollPosition`.
   *
   * @param {DOMWindow|DOMElement} scrollable
   * @return {object} Map with `x` and `y` keys.
   */
  function getScrollPosition(scrollable) {
    var documentScrollElement = getDocumentScrollElement(scrollable.ownerDocument || scrollable.document);
    if (scrollable.Window && scrollable instanceof scrollable.Window) {
      scrollable = documentScrollElement;
    }
    var scrollPosition = getUnboundedScrollPosition(scrollable);

    var viewport = scrollable === documentScrollElement ? scrollable.ownerDocument.documentElement : scrollable;

    var xMax = scrollable.scrollWidth - viewport.clientWidth;
    var yMax = scrollable.scrollHeight - viewport.clientHeight;

    scrollPosition.x = Math.max(0, Math.min(scrollPosition.x, xMax));
    scrollPosition.y = Math.max(0, Math.min(scrollPosition.y, yMax));

    return scrollPosition;
  }

  module.exports = getScrollPosition;
});
//# sourceMappingURL=getScrollPosition.js.map