"use strict";

Liferay.Loader.define("frontend-js-react-web$react-dnd@11.1.1/dist/cjs/hooks/internal/drop", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../common/registration', '../useDragDropManager', '../../common/TargetConnector', '../../common/DropTargetMonitorImpl', './useIsomorphicLayoutEffect'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useDropTargetMonitor = useDropTargetMonitor;
    exports.useDropHandler = useDropHandler;

    var _react = require("frontend-js-react-web$react");

    var _registration = require("../../common/registration");

    var _useDragDropManager = require("../useDragDropManager");

    var _TargetConnector = require("../../common/TargetConnector");

    var _DropTargetMonitorImpl = require("../../common/DropTargetMonitorImpl");

    var _useIsomorphicLayoutEffect = require("./useIsomorphicLayoutEffect");

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }

    function _unsupportedIterableToArray(o, minLen) {
      if (!o) return;if (typeof o === "string") return _arrayLikeToArray(o, minLen);var n = Object.prototype.toString.call(o).slice(8, -1);if (n === "Object" && o.constructor) n = o.constructor.name;if (n === "Map" || n === "Set") return Array.from(o);if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen);
    }

    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length) len = arr.length;for (var i = 0, arr2 = new Array(len); i < len; i++) {
        arr2[i] = arr[i];
      }return arr2;
    }

    function _iterableToArrayLimit(arr, i) {
      if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return;var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function useDropTargetMonitor() {
      var manager = (0, _useDragDropManager.useDragDropManager)();
      var monitor = (0, _react.useMemo)(function () {
        return new _DropTargetMonitorImpl.DropTargetMonitorImpl(manager);
      }, [manager]);
      var connector = (0, _react.useMemo)(function () {
        return new _TargetConnector.TargetConnector(manager.getBackend());
      }, [manager]);
      return [monitor, connector];
    }

    function useDropHandler(spec, monitor, connector) {
      var manager = (0, _useDragDropManager.useDragDropManager)();
      var handler = (0, _react.useMemo)(function () {
        return {
          canDrop: function canDrop() {
            var canDrop = spec.current.canDrop;
            return canDrop ? canDrop(monitor.getItem(), monitor) : true;
          },
          hover: function hover() {
            var hover = spec.current.hover;

            if (hover) {
              hover(monitor.getItem(), monitor);
            }
          },
          drop: function drop() {
            var drop = spec.current.drop;

            if (drop) {
              return drop(monitor.getItem(), monitor);
            }
          }
        };
      }, [monitor]);
      (0, _useIsomorphicLayoutEffect.useIsomorphicLayoutEffect)(function registerHandler() {
        var _registerTarget = (0, _registration.registerTarget)(spec.current.accept, handler, manager),
            _registerTarget2 = _slicedToArray(_registerTarget, 2),
            handlerId = _registerTarget2[0],
            unregister = _registerTarget2[1];

        monitor.receiveHandlerId(handlerId);
        connector.receiveHandlerId(handlerId);
        return unregister;
      }, [monitor, connector]);
    }
  }
});
//# sourceMappingURL=drop.js.map