"use strict";

Liferay.Loader.define("frontend-js-react-web$react-dnd@11.1.1/dist/cjs/common/SourceConnector", ['module', 'exports', 'require', './wrapConnectorHooks', '../utils/isRef', '@frontend-js-react-web$react-dnd/shallowequal'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.SourceConnector = void 0;

    var _wrapConnectorHooks = require("./wrapConnectorHooks");

    var _isRef = require("../utils/isRef");

    var _shallowequal = require("@frontend-js-react-web$react-dnd/shallowequal");

    function _classCallCheck(instance, Constructor) {
      if (!(instance instanceof Constructor)) {
        throw new TypeError("Cannot call a class as a function");
      }
    }

    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
      }
    }

    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
    }

    var SourceConnector = /*#__PURE__*/function () {
      function SourceConnector(backend) {
        var _this = this;

        _classCallCheck(this, SourceConnector);

        this.hooks = (0, _wrapConnectorHooks.wrapConnectorHooks)({
          dragSource: function dragSource(node, options) {
            _this.clearDragSource();

            _this.dragSourceOptions = options || null;

            if ((0, _isRef.isRef)(node)) {
              _this.dragSourceRef = node;
            } else {
              _this.dragSourceNode = node;
            }

            _this.reconnectDragSource();
          },
          dragPreview: function dragPreview(node, options) {
            _this.clearDragPreview();

            _this.dragPreviewOptions = options || null;

            if ((0, _isRef.isRef)(node)) {
              _this.dragPreviewRef = node;
            } else {
              _this.dragPreviewNode = node;
            }

            _this.reconnectDragPreview();
          }
        });
        this.handlerId = null; // The drop target may either be attached via ref or connect function

        this.dragSourceRef = null;
        this.dragSourceOptionsInternal = null; // The drag preview may either be attached via ref or connect function

        this.dragPreviewRef = null;
        this.dragPreviewOptionsInternal = null;
        this.lastConnectedHandlerId = null;
        this.lastConnectedDragSource = null;
        this.lastConnectedDragSourceOptions = null;
        this.lastConnectedDragPreview = null;
        this.lastConnectedDragPreviewOptions = null;
        this.backend = backend;
      }

      _createClass(SourceConnector, [{
        key: "receiveHandlerId",
        value: function receiveHandlerId(newHandlerId) {
          if (this.handlerId === newHandlerId) {
            return;
          }

          this.handlerId = newHandlerId;
          this.reconnect();
        }
      }, {
        key: "reconnect",
        value: function reconnect() {
          this.reconnectDragSource();
          this.reconnectDragPreview();
        }
      }, {
        key: "reconnectDragSource",
        value: function reconnectDragSource() {
          var dragSource = this.dragSource; // if nothing has changed then don't resubscribe

          var didChange = this.didHandlerIdChange() || this.didConnectedDragSourceChange() || this.didDragSourceOptionsChange();

          if (didChange) {
            this.disconnectDragSource();
          }

          if (!this.handlerId) {
            return;
          }

          if (!dragSource) {
            this.lastConnectedDragSource = dragSource;
            return;
          }

          if (didChange) {
            this.lastConnectedHandlerId = this.handlerId;
            this.lastConnectedDragSource = dragSource;
            this.lastConnectedDragSourceOptions = this.dragSourceOptions;
            this.dragSourceUnsubscribe = this.backend.connectDragSource(this.handlerId, dragSource, this.dragSourceOptions);
          }
        }
      }, {
        key: "reconnectDragPreview",
        value: function reconnectDragPreview() {
          var dragPreview = this.dragPreview; // if nothing has changed then don't resubscribe

          var didChange = this.didHandlerIdChange() || this.didConnectedDragPreviewChange() || this.didDragPreviewOptionsChange();

          if (didChange) {
            this.disconnectDragPreview();
          }

          if (!this.handlerId) {
            return;
          }

          if (!dragPreview) {
            this.lastConnectedDragPreview = dragPreview;
            return;
          }

          if (didChange) {
            this.lastConnectedHandlerId = this.handlerId;
            this.lastConnectedDragPreview = dragPreview;
            this.lastConnectedDragPreviewOptions = this.dragPreviewOptions;
            this.dragPreviewUnsubscribe = this.backend.connectDragPreview(this.handlerId, dragPreview, this.dragPreviewOptions);
          }
        }
      }, {
        key: "didHandlerIdChange",
        value: function didHandlerIdChange() {
          return this.lastConnectedHandlerId !== this.handlerId;
        }
      }, {
        key: "didConnectedDragSourceChange",
        value: function didConnectedDragSourceChange() {
          return this.lastConnectedDragSource !== this.dragSource;
        }
      }, {
        key: "didConnectedDragPreviewChange",
        value: function didConnectedDragPreviewChange() {
          return this.lastConnectedDragPreview !== this.dragPreview;
        }
      }, {
        key: "didDragSourceOptionsChange",
        value: function didDragSourceOptionsChange() {
          return !(0, _shallowequal.shallowEqual)(this.lastConnectedDragSourceOptions, this.dragSourceOptions);
        }
      }, {
        key: "didDragPreviewOptionsChange",
        value: function didDragPreviewOptionsChange() {
          return !(0, _shallowequal.shallowEqual)(this.lastConnectedDragPreviewOptions, this.dragPreviewOptions);
        }
      }, {
        key: "disconnectDragSource",
        value: function disconnectDragSource() {
          if (this.dragSourceUnsubscribe) {
            this.dragSourceUnsubscribe();
            this.dragSourceUnsubscribe = undefined;
          }
        }
      }, {
        key: "disconnectDragPreview",
        value: function disconnectDragPreview() {
          if (this.dragPreviewUnsubscribe) {
            this.dragPreviewUnsubscribe();
            this.dragPreviewUnsubscribe = undefined;
            this.dragPreviewNode = null;
            this.dragPreviewRef = null;
          }
        }
      }, {
        key: "clearDragSource",
        value: function clearDragSource() {
          this.dragSourceNode = null;
          this.dragSourceRef = null;
        }
      }, {
        key: "clearDragPreview",
        value: function clearDragPreview() {
          this.dragPreviewNode = null;
          this.dragPreviewRef = null;
        }
      }, {
        key: "connectTarget",
        get: function get() {
          return this.dragSource;
        }
      }, {
        key: "dragSourceOptions",
        get: function get() {
          return this.dragSourceOptionsInternal;
        },
        set: function set(options) {
          this.dragSourceOptionsInternal = options;
        }
      }, {
        key: "dragPreviewOptions",
        get: function get() {
          return this.dragPreviewOptionsInternal;
        },
        set: function set(options) {
          this.dragPreviewOptionsInternal = options;
        }
      }, {
        key: "dragSource",
        get: function get() {
          return this.dragSourceNode || this.dragSourceRef && this.dragSourceRef.current;
        }
      }, {
        key: "dragPreview",
        get: function get() {
          return this.dragPreviewNode || this.dragPreviewRef && this.dragPreviewRef.current;
        }
      }]);

      return SourceConnector;
    }();

    exports.SourceConnector = SourceConnector;
  }
});
//# sourceMappingURL=SourceConnector.js.map