/**
 * Copyright (c) 2013-present, Facebook, Inc.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */

'use strict';

// React 15.5 references this module, and assumes PropTypes are still callable in production.
// Therefore we re-export development-only version with all the PropTypes checks here.
// However if one is migrating to the `prop-types` npm library, they will go through the
// `index.js` entry point, and it will branch depending on the environment.

Liferay.Loader.define('frontend-js-react-web$prop-types@15.7.2/factory', ['module', 'exports', 'require', './factoryWithTypeCheckers'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var factory = require('./factoryWithTypeCheckers');
    module.exports = function (isValidElement) {
      return factory(isValidElement, false);
      // It is still allowed in 15.5.
    };
  }
});
//# sourceMappingURL=factory.js.map