Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/toSafeInteger', ['module', 'exports', 'require', './_baseClamp', './toInteger'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var baseClamp = require('./_baseClamp'),
            toInteger = require('./toInteger');

        /** Used as references for various `Number` constants. */
        var MAX_SAFE_INTEGER = 9007199254740991;

        /**
         * Converts `value` to a safe integer. A safe integer can be compared and
         * represented correctly.
         *
         * @static
         * @memberOf _
         * @since 4.0.0
         * @category Lang
         * @param {*} value The value to convert.
         * @returns {number} Returns the converted integer.
         * @example
         *
         * _.toSafeInteger(3.2);
         * // => 3
         *
         * _.toSafeInteger(Number.MIN_VALUE);
         * // => 0
         *
         * _.toSafeInteger(Infinity);
         * // => 9007199254740991
         *
         * _.toSafeInteger('3.2');
         * // => 3
         */
        function toSafeInteger(value) {
            return value ? baseClamp(toInteger(value), -MAX_SAFE_INTEGER, MAX_SAFE_INTEGER) : value === 0 ? value : 0;
        }

        module.exports = toSafeInteger;
    }
});
//# sourceMappingURL=toSafeInteger.js.map