Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/isWeakMap', ['module', 'exports', 'require', './_getTag', './isObjectLike'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var getTag = require('./_getTag'),
        isObjectLike = require('./isObjectLike');

    /** `Object#toString` result references. */
    var weakMapTag = '[object WeakMap]';

    /**
     * Checks if `value` is classified as a `WeakMap` object.
     *
     * @static
     * @memberOf _
     * @since 4.3.0
     * @category Lang
     * @param {*} value The value to check.
     * @returns {boolean} Returns `true` if `value` is a weak map, else `false`.
     * @example
     *
     * _.isWeakMap(new WeakMap);
     * // => true
     *
     * _.isWeakMap(new Map);
     * // => false
     */
    function isWeakMap(value) {
      return isObjectLike(value) && getTag(value) == weakMapTag;
    }

    module.exports = isWeakMap;
  }
});
//# sourceMappingURL=isWeakMap.js.map