Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/functionsIn', ['module', 'exports', 'require', './_baseFunctions', './keysIn'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseFunctions = require('./_baseFunctions'),
        keysIn = require('./keysIn');

    /**
     * Creates an array of function property names from own and inherited
     * enumerable properties of `object`.
     *
     * @static
     * @memberOf _
     * @since 4.0.0
     * @category Object
     * @param {Object} object The object to inspect.
     * @returns {Array} Returns the function names.
     * @see _.functions
     * @example
     *
     * function Foo() {
     *   this.a = _.constant('a');
     *   this.b = _.constant('b');
     * }
     *
     * Foo.prototype.c = _.constant('c');
     *
     * _.functionsIn(new Foo);
     * // => ['a', 'b', 'c']
     */
    function functionsIn(object) {
      return object == null ? [] : baseFunctions(object, keysIn(object));
    }

    module.exports = functionsIn;
  }
});
//# sourceMappingURL=functionsIn.js.map