Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/forIn', ['module', 'exports', 'require', './_baseFor', './_castFunction', './keysIn'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var baseFor = require('./_baseFor'),
            castFunction = require('./_castFunction'),
            keysIn = require('./keysIn');

        /**
         * Iterates over own and inherited enumerable string keyed properties of an
         * object and invokes `iteratee` for each property. The iteratee is invoked
         * with three arguments: (value, key, object). Iteratee functions may exit
         * iteration early by explicitly returning `false`.
         *
         * @static
         * @memberOf _
         * @since 0.3.0
         * @category Object
         * @param {Object} object The object to iterate over.
         * @param {Function} [iteratee=_.identity] The function invoked per iteration.
         * @returns {Object} Returns `object`.
         * @see _.forInRight
         * @example
         *
         * function Foo() {
         *   this.a = 1;
         *   this.b = 2;
         * }
         *
         * Foo.prototype.c = 3;
         *
         * _.forIn(new Foo, function(value, key) {
         *   console.log(key);
         * });
         * // => Logs 'a', 'b', then 'c' (iteration order is not guaranteed).
         */
        function forIn(object, iteratee) {
            return object == null ? object : baseFor(object, castFunction(iteratee), keysIn);
        }

        module.exports = forIn;
    }
});
//# sourceMappingURL=forIn.js.map