Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/findLastKey', ['module', 'exports', 'require', './_baseFindKey', './_baseForOwnRight', './_baseIteratee'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseFindKey = require('./_baseFindKey'),
        baseForOwnRight = require('./_baseForOwnRight'),
        baseIteratee = require('./_baseIteratee');

    /**
     * This method is like `_.findKey` except that it iterates over elements of
     * a collection in the opposite order.
     *
     * @static
     * @memberOf _
     * @since 2.0.0
     * @category Object
     * @param {Object} object The object to inspect.
     * @param {Function} [predicate=_.identity] The function invoked per iteration.
     * @returns {string|undefined} Returns the key of the matched element,
     *  else `undefined`.
     * @example
     *
     * var users = {
     *   'barney':  { 'age': 36, 'active': true },
     *   'fred':    { 'age': 40, 'active': false },
     *   'pebbles': { 'age': 1,  'active': true }
     * };
     *
     * _.findLastKey(users, function(o) { return o.age < 40; });
     * // => returns 'pebbles' assuming `_.findKey` returns 'barney'
     *
     * // The `_.matches` iteratee shorthand.
     * _.findLastKey(users, { 'age': 36, 'active': true });
     * // => 'barney'
     *
     * // The `_.matchesProperty` iteratee shorthand.
     * _.findLastKey(users, ['active', false]);
     * // => 'fred'
     *
     * // The `_.property` iteratee shorthand.
     * _.findLastKey(users, 'active');
     * // => 'pebbles'
     */
    function findLastKey(object, predicate) {
      return baseFindKey(object, baseIteratee(predicate, 3), baseForOwnRight);
    }

    module.exports = findLastKey;
  }
});
//# sourceMappingURL=findLastKey.js.map