Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/_shuffleSelf', ['module', 'exports', 'require', './_baseRandom'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        var baseRandom = require('./_baseRandom');

        /**
         * A specialized version of `_.shuffle` which mutates and sets the size of `array`.
         *
         * @private
         * @param {Array} array The array to shuffle.
         * @param {number} [size=array.length] The size of `array`.
         * @returns {Array} Returns `array`.
         */
        function shuffleSelf(array, size) {
            var index = -1,
                length = array.length;

            size = size === undefined ? length : size;
            while (++index < size) {
                var rand = baseRandom(index, length - 1),
                    value = array[rand];

                array[rand] = array[index];
                array[index] = value;
            }
            array.length = size;
            return array;
        }

        module.exports = shuffleSelf;
    }
});
//# sourceMappingURL=_shuffleSelf.js.map