Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/_createPadding', ['module', 'exports', 'require', './_baseRepeat', './_baseToString', './_castSlice', './_hasUnicode', './_stringSize', './_stringToArray'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var baseRepeat = require('./_baseRepeat'),
        baseToString = require('./_baseToString'),
        castSlice = require('./_castSlice'),
        hasUnicode = require('./_hasUnicode'),
        stringSize = require('./_stringSize'),
        stringToArray = require('./_stringToArray');

    /* Built-in method references for those with the same name as other `lodash` methods. */
    var nativeCeil = Math.ceil;

    /**
     * Creates the padding for `string` based on `length`. The `chars` string
     * is truncated if the number of characters exceeds `length`.
     *
     * @private
     * @param {number} length The padding length.
     * @param {string} [chars=' '] The string used as padding.
     * @returns {string} Returns the padding for `string`.
     */
    function createPadding(length, chars) {
      chars = chars === undefined ? ' ' : baseToString(chars);

      var charsLength = chars.length;
      if (charsLength < 2) {
        return charsLength ? baseRepeat(chars, length) : chars;
      }
      var result = baseRepeat(chars, nativeCeil(length / stringSize(chars)));
      return hasUnicode(chars) ? castSlice(stringToArray(result), 0, length).join('') : result.slice(0, length);
    }

    module.exports = createPadding;
  }
});
//# sourceMappingURL=_createPadding.js.map