Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/_createCurry', ['module', 'exports', 'require', './_apply', './_createCtor', './_createHybrid', './_createRecurry', './_getHolder', './_replaceHolders', './_root'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var apply = require('./_apply'),
        createCtor = require('./_createCtor'),
        createHybrid = require('./_createHybrid'),
        createRecurry = require('./_createRecurry'),
        getHolder = require('./_getHolder'),
        replaceHolders = require('./_replaceHolders'),
        root = require('./_root');

    /**
     * Creates a function that wraps `func` to enable currying.
     *
     * @private
     * @param {Function} func The function to wrap.
     * @param {number} bitmask The bitmask flags. See `createWrap` for more details.
     * @param {number} arity The arity of `func`.
     * @returns {Function} Returns the new wrapped function.
     */
    function createCurry(func, bitmask, arity) {
      var Ctor = createCtor(func);

      function wrapper() {
        var length = arguments.length,
            args = Array(length),
            index = length,
            placeholder = getHolder(wrapper);

        while (index--) {
          args[index] = arguments[index];
        }
        var holders = length < 3 && args[0] !== placeholder && args[length - 1] !== placeholder ? [] : replaceHolders(args, placeholder);

        length -= holders.length;
        if (length < arity) {
          return createRecurry(func, bitmask, createHybrid, wrapper.placeholder, undefined, args, holders, undefined, undefined, arity - length);
        }
        var fn = this && this !== root && this instanceof wrapper ? Ctor : func;
        return apply(fn, this, args);
      }
      return wrapper;
    }

    module.exports = createCurry;
  }
});
//# sourceMappingURL=_createCurry.js.map