Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/_createCaseFirst', ['module', 'exports', 'require', './_castSlice', './_hasUnicode', './_stringToArray', './toString'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var castSlice = require('./_castSlice'),
        hasUnicode = require('./_hasUnicode'),
        stringToArray = require('./_stringToArray'),
        toString = require('./toString');

    /**
     * Creates a function like `_.lowerFirst`.
     *
     * @private
     * @param {string} methodName The name of the `String` case method to use.
     * @returns {Function} Returns the new case function.
     */
    function createCaseFirst(methodName) {
      return function (string) {
        string = toString(string);

        var strSymbols = hasUnicode(string) ? stringToArray(string) : undefined;

        var chr = strSymbols ? strSymbols[0] : string.charAt(0);

        var trailing = strSymbols ? castSlice(strSymbols, 1).join('') : string.slice(1);

        return chr[methodName]() + trailing;
      };
    }

    module.exports = createCaseFirst;
  }
});
//# sourceMappingURL=_createCaseFirst.js.map