Liferay.Loader.define('frontend-js-react-web$lodash@4.17.19/_baseSet', ['module', 'exports', 'require', './_assignValue', './_castPath', './_isIndex', './isObject', './_toKey'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    var assignValue = require('./_assignValue'),
        castPath = require('./_castPath'),
        isIndex = require('./_isIndex'),
        isObject = require('./isObject'),
        toKey = require('./_toKey');

    /**
     * The base implementation of `_.set`.
     *
     * @private
     * @param {Object} object The object to modify.
     * @param {Array|string} path The path of the property to set.
     * @param {*} value The value to set.
     * @param {Function} [customizer] The function to customize path creation.
     * @returns {Object} Returns `object`.
     */
    function baseSet(object, path, value, customizer) {
      if (!isObject(object)) {
        return object;
      }
      path = castPath(path, object);

      var index = -1,
          length = path.length,
          nested = object;

      while (nested != null && ++index < length) {
        var key = toKey(path[index]),
            newValue = value;

        if (index != length - 1) {
          var objValue = nested[key];
          newValue = customizer ? customizer(objValue, key, nested) : undefined;
          if (newValue === undefined) {
            newValue = isObject(objValue) ? objValue : isIndex(path[index + 1]) ? [] : {};
          }
        }
        assignValue(nested, key, newValue);
        nested = nested[key];
      }
      return object;
    }

    module.exports = baseSet;
  }
});
//# sourceMappingURL=_baseSet.js.map