Liferay.Loader.define("frontend-js-react-web@4.0.16/js/hooks/useTimeout.es", ['module', 'exports', 'require', 'frontend-js-react-web$react', './useIsMounted.es'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports["default"] = useTimeout;

    var _react = require("frontend-js-react-web$react");

    var _useIsMounted = _interopRequireDefault(require("./useIsMounted.es"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Hook for delaying a function call by the specified interval (in
     * milliseconds).
     */
    function useTimeout() {
      var isMounted = (0, _useIsMounted["default"])();
      return (0, _react.useCallback)(function delay(fn, ms) {
        var handle = setTimeout(function () {
          if (isMounted()) {
            fn();
          }
        }, ms);
        return function () {
          return clearTimeout(handle);
        };
      }, [isMounted]);
    }
    //# sourceMappingURL=useTimeout.es.js.map
  }
});
//# sourceMappingURL=useTimeout.es.js.map