Liferay.Loader.define("frontend-js-node-shims$console-browserify@1.1.0/index", ['module', 'exports', 'require', 'frontend-js-node-shims$util', 'frontend-js-node-shims$assert', 'frontend-js-node-shims$date-now'], function (module, exports, require) {
    var define = undefined;
    /*global window, global*/
    var util = require("frontend-js-node-shims$util");
    var assert = require("frontend-js-node-shims$assert");
    var now = require("frontend-js-node-shims$date-now");

    var slice = Array.prototype.slice;
    var console;
    var times = {};

    if (typeof global !== "undefined" && global.console) {
        console = global.console;
    } else if (typeof window !== "undefined" && window.console) {
        console = window.console;
    } else {
        console = {};
    }

    var functions = [[log, "log"], [info, "info"], [warn, "warn"], [error, "error"], [time, "time"], [timeEnd, "timeEnd"], [trace, "trace"], [dir, "dir"], [consoleAssert, "assert"]];

    for (var i = 0; i < functions.length; i++) {
        var tuple = functions[i];
        var f = tuple[0];
        var name = tuple[1];

        if (!console[name]) {
            console[name] = f;
        }
    }

    module.exports = console;

    function log() {}

    function info() {
        console.log.apply(console, arguments);
    }

    function warn() {
        console.log.apply(console, arguments);
    }

    function error() {
        console.warn.apply(console, arguments);
    }

    function time(label) {
        times[label] = now();
    }

    function timeEnd(label) {
        var time = times[label];
        if (!time) {
            throw new Error("No such label: " + label);
        }

        var duration = now() - time;
        console.log(label + ": " + duration + "ms");
    }

    function trace() {
        var err = new Error();
        err.name = "Trace";
        err.message = util.format.apply(null, arguments);
        console.error(err.stack);
    }

    function dir(object) {
        console.log(util.inspect(object) + "\n");
    }

    function consoleAssert(expression) {
        if (!expression) {
            var arr = slice.call(arguments, 1);
            assert.ok(false, util.format.apply(null, arr));
        }
    }
});
//# sourceMappingURL=index.js.map