'use strict';

/**
 * Debounces function execution.
 * @param {!function()} fn
 * @param {number} [delay=0]
 * @return {!function()}
 */

Liferay.Loader.define('frontend-js-metal-web$metal-throttle@3.0.1/src/throttle', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		function throttle(fn, delay = 0) {
			let last = 0;

			return (...args) => {
				const next = last + delay;
				const now = Date.now();

				if (next < now) {
					try {
						fn.call(null, ...args);
					} catch (error) {
						throw error;
					} finally {
						last = Date.now();
					}
				}
			};
		}

		export default throttle;
		export { throttle };
	}
});
//# sourceMappingURL=throttle.js.map