'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-state@2.7.0/lib/State", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		Object.defineProperty(exports, "__esModule", {
			value: true
		});

		var _createClass = function () {
			function defineProperties(target, props) {
				for (var i = 0; i < props.length; i++) {
					var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
				}
			}return function (Constructor, protoProps, staticProps) {
				if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
			};
		}();

		var _get = function get(object, property, receiver) {
			if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
				var parent = Object.getPrototypeOf(object);if (parent === null) {
					return undefined;
				} else {
					return get(parent, property, receiver);
				}
			} else if ("value" in desc) {
				return desc.value;
			} else {
				var getter = desc.get;if (getter === undefined) {
					return undefined;
				}return getter.call(receiver);
			}
		};

		var _metal = require("frontend-js-metal-web$metal");

		var _metalEvents = require("frontend-js-metal-web$metal-events");

		function _classCallCheck(instance, Constructor) {
			if (!(instance instanceof Constructor)) {
				throw new TypeError("Cannot call a class as a function");
			}
		}

		function _possibleConstructorReturn(self, call) {
			if (!self) {
				throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
			}return call && (typeof call === "object" || typeof call === "function") ? call : self;
		}

		function _inherits(subClass, superClass) {
			if (typeof superClass !== "function" && superClass !== null) {
				throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
			}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
		}

		/**
   * State adds support for having object properties that can be watched for
   * changes, as well as configured with validators, setters and other options.
   * See the `configState` method for a complete list of available configuration
   * options for each state key.
   * @extends {EventEmitter}
   */
		var State = function (_EventEmitter) {
			_inherits(State, _EventEmitter);

			/**
    * Constructor function for `State`.
    * @param {Object=} opt_config Optional config object with initial values to
    *     set state properties to.
    * @param {Object=} opt_obj Optional object that should hold the state
    *     properties. If none is given, they will be added directly to `this`
    *     instead.
    * @param {Object=} opt_context Optional context to call functions (like
    *     validators and setters) on. Defaults to `this`.
    */
			function State(opt_config, opt_obj, opt_context) {
				_classCallCheck(this, State);

				/**
     * Context to call functions (like validators and setters) on.
     * @type {!Object}
     * @protected
     */
				var _this = _possibleConstructorReturn(this, (State.__proto__ || Object.getPrototypeOf(State)).call(this));

				_this.context_ = opt_context || _this;

				/**
     * Map of keys that can not be used as state keys.
     * @type {Object<string, boolean>}
     * @protected
     */
				_this.keysBlacklist_ = null;

				/**
     * Object that should hold the state properties.
     * @type {!Object}
     * @protected
     */
				_this.obj_ = opt_obj || _this;

				_this.eventData_ = null;

				/**
     * Object with information about the batch event that is currently
     * scheduled, or null if none is.
     * @type {Object}
     * @protected
     */
				_this.scheduledBatchData_ = null;

				/**
     * Object that contains information about all this instance's state keys.
     * @type {!Object<string, !Object>}
     * @protected
     */
				_this.stateInfo_ = {};

				_this.stateConfigs_ = {};

				_this.initialValues_ = _metal.object.mixin({}, opt_config);

				_this.setShouldUseFacade(true);
				_this.configStateFromStaticHint_();

				Object.defineProperty(_this.obj_, State.STATE_REF_KEY, {
					configurable: true,
					enumerable: false,
					value: _this
				});
				return _this;
			}

			/**
    * Logs an error if the given property is required but wasn't given.
    * @param {string} name
    * @protected
    */

			_createClass(State, [{
				key: 'assertGivenIfRequired_',
				value: function assertGivenIfRequired_(name) {
					var config = this.stateConfigs_[name];
					if (config.required) {
						var info = this.getStateInfo(name);
						var value = info.state === State.KeyStates.INITIALIZED ? this.get(name) : this.initialValues_[name];
						if (!(0, _metal.isDefAndNotNull)(value)) {
							var errorMessage = 'The property called "' + name + '" is required but didn\'t receive a value.';
							if (this.shouldThrowValidationError()) {
								throw new Error(errorMessage);
							} else {
								console.error(errorMessage);
							}
						}
					}
				}

				/**
     * Logs an error if the `validatorReturn` is instance of `Error`.
     * @param {*} validatorReturn
     * @protected
     */

			}, {
				key: 'assertValidatorReturnInstanceOfError_',
				value: function assertValidatorReturnInstanceOfError_(validatorReturn) {
					if (validatorReturn instanceof Error) {
						if (this.shouldThrowValidationError()) {
							throw validatorReturn;
						} else {
							console.error('Warning: ' + validatorReturn);
						}
					}
				}

				/**
     * Checks that the given name is a valid state key name. If it's not, an error
     * will be thrown.
     * @param {string} name The name to be validated.
     * @throws {Error}
     * @protected
     */

			}, {
				key: 'assertValidStateKeyName_',
				value: function assertValidStateKeyName_(name) {
					if (this.keysBlacklist_ && this.keysBlacklist_[name]) {
						throw new Error('It\'s not allowed to create a state key with the name "' + name + '".');
					}
				}

				/**
     * Builds the property definition object for the specified state key.
     * @param {string} name The name of the key.
     * @return {!Object}
     * @protected
     */

			}, {
				key: 'buildKeyPropertyDef_',
				value: function buildKeyPropertyDef_(name) {
					return {
						configurable: true,
						enumerable: true,
						get: function get() {
							return this[State.STATE_REF_KEY].getStateKeyValue_(name);
						},
						set: function set(val) {
							this[State.STATE_REF_KEY].setStateKeyValue_(name, val);
						}
					};
				}

				/**
     * Calls the requested function, running the appropriate code for when it's
     * passed as an actual function object or just the function's name.
     * @param {!Function|string} fn Function, or name of the function to run.
     * @param {!Array} An optional array of parameters to be passed to the
     *   function that will be called.
     * @return {*} The return value of the called function.
     * @protected
     */

			}, {
				key: 'callFunction_',
				value: function callFunction_(fn, args) {
					if ((0, _metal.isString)(fn)) {
						return this.context_[fn].apply(this.context_, args);
					} else if ((0, _metal.isFunction)(fn)) {
						return fn.apply(this.context_, args);
					}
				}

				/**
     * Calls the state key's setter, if there is one.
     * @param {string} name The name of the key.
     * @param {*} value The value to be set.
     * @param {*} currentValue The current value.
     * @return {*} The final value to be set.
     * @protected
     */

			}, {
				key: 'callSetter_',
				value: function callSetter_(name, value, currentValue) {
					var config = this.stateConfigs_[name];
					if (config.setter) {
						value = this.callFunction_(config.setter, [value, currentValue]);
					}
					return value;
				}

				/**
     * Calls the state key's validator, if there is one. Emits console
     * warning if validator returns a string.
     * @param {string} name The name of the key.
     * @param {*} value The value to be validated.
     * @return {boolean} Flag indicating if value is valid or not.
     * @protected
     */

			}, {
				key: 'callValidator_',
				value: function callValidator_(name, value) {
					var config = this.stateConfigs_[name];
					if (config.validator) {
						var validatorReturn = this.callFunction_(config.validator, [value, name, this.context_]);
						this.assertValidatorReturnInstanceOfError_(validatorReturn);
						return validatorReturn;
					}
					return true;
				}

				/**
     * Checks if the it's allowed to write on the requested state key.
     * @param {string} name The name of the key.
     * @return {boolean}
     */

			}, {
				key: 'canSetState',
				value: function canSetState(name) {
					var info = this.getStateInfo(name);
					return !this.stateConfigs_[name].writeOnce || !info.written;
				}

				/**
     * Adds the given key(s) to the state, together with its(their) configs.
     * Config objects support the given settings:
     *     required - When set to `true`, causes errors to be printed (via
     *     `console.error`) if no value is given for the property.
     *
     *     setter - Function for normalizing state key values. It receives the new
     *     value that was set, and returns the value that should be stored.
     *
     *     validator - Function that validates state key values. When it returns
     *     false, the new value is ignored. When it returns an instance of Error,
     *     it will emit the error to the console.
     *
     *     value - The default value for the state key. Note that setting this to
     *     an object will cause all class instances to use the same reference to
     *     the object. To have each instance use a different reference for objects,
     *     use the `valueFn` option instead.
     *
     *     valueFn - A function that returns the default value for a state key.
     *
     *     writeOnce - Ignores writes to the state key after it's been first
     *     written to. That is, allows writes only when setting the value for the
     *     first time.
     * @param {!Object.<string, !Object>|string} configs An object that maps
     *     configuration options for keys to be added to the state.
     * @param {boolean|Object|*=} opt_context The context where the added state
     *     keys will be defined (defaults to `this`), or false if they shouldn't
     *     be defined at all.
     */

			}, {
				key: 'configState',
				value: function configState(configs, opt_context) {
					var names = Object.keys(configs);
					if (names.length === 0) {
						return;
					}

					if (opt_context !== false) {
						var props = {};
						for (var i = 0; i < names.length; i++) {
							var name = names[i];
							this.assertValidStateKeyName_(name);
							props[name] = this.buildKeyPropertyDef_(name);
						}
						Object.defineProperties(opt_context || this.obj_, props);
					}

					this.stateConfigs_ = configs;
					for (var _i = 0; _i < names.length; _i++) {
						var _name = names[_i];
						configs[_name] = configs[_name].config ? configs[_name].config : configs[_name];
						this.assertGivenIfRequired_(names[_i]);
						this.validateInitialValue_(names[_i]);
					}
				}

				/**
     * Adds state keys from super classes static hint `MyClass.STATE = {};`.
     * @param {Object.<string, !Object>=} opt_config An object that maps all the
     *     configurations for state keys.
     * @protected
     */

			}, {
				key: 'configStateFromStaticHint_',
				value: function configStateFromStaticHint_() {
					var ctor = this.constructor;
					if (ctor !== State) {
						var defineContext = void 0;
						if (this.obj_ === this) {
							defineContext = ctor.hasConfiguredState_ ? false : ctor.prototype;
							ctor.hasConfiguredState_ = true;
						}
						this.configState(State.getStateStatic(ctor), defineContext);
					}
				}

				/**
     * @inheritDoc
     */

			}, {
				key: 'disposeInternal',
				value: function disposeInternal() {
					_get(State.prototype.__proto__ || Object.getPrototypeOf(State.prototype), 'disposeInternal', this).call(this);
					this.initialValues_ = null;
					this.stateInfo_ = null;
					this.stateConfigs_ = null;
					this.scheduledBatchData_ = null;
				}

				/**
     * Emits the state change batch event.
     * @protected
     */

			}, {
				key: 'emitBatchEvent_',
				value: function emitBatchEvent_() {
					if (!this.isDisposed()) {
						var data = this.scheduledBatchData_;
						this.scheduledBatchData_ = null;
						this.context_.emit('stateChanged', data);
					}
				}

				/**
     * Returns the value of the requested state key.
     * Note: this can and should be accomplished by accessing the value as a
     * regular property. This should only be used in cases where a function is
     * actually needed.
     * @param {string} name
     * @return {*}
     */

			}, {
				key: 'get',
				value: function get(name) {
					return this.obj_[name];
				}

				/**
     * Returns an object that maps state keys to their values.
     * @param {Array<string>=} opt_names A list of names of the keys that should
     *   be returned. If none is given, the whole state will be returned.
     * @return {Object.<string, *>}
     */

			}, {
				key: 'getState',
				value: function getState(opt_names) {
					var state = {};
					var names = opt_names || this.getStateKeys();

					for (var i = 0; i < names.length; i++) {
						state[names[i]] = this.get(names[i]);
					}

					return state;
				}

				/**
     * Gets information about the specified state property.
     * @param {string} name
     * @return {!Object}
     */

			}, {
				key: 'getStateInfo',
				value: function getStateInfo(name) {
					if (!this.stateInfo_[name]) {
						this.stateInfo_[name] = {};
					}
					return this.stateInfo_[name];
				}

				/**
     * Gets the config object for the requested state key.
     * @param {string} name The key's name.
     * @return {Object}
     * @protected
     */

			}, {
				key: 'getStateKeyConfig',
				value: function getStateKeyConfig(name) {
					return this.stateConfigs_ ? this.stateConfigs_[name] : null;
				}

				/**
     * Returns an array with all state keys.
     * @return {!Array.<string>}
     */

			}, {
				key: 'getStateKeys',
				value: function getStateKeys() {
					return this.stateConfigs_ ? Object.keys(this.stateConfigs_) : [];
				}

				/**
     * Gets the value of the specified state key. This is passed as that key's
     * getter to the `Object.defineProperty` call inside the `addKeyToState` method.
     * @param {string} name The name of the key.
     * @return {*}
     * @protected
     */

			}, {
				key: 'getStateKeyValue_',
				value: function getStateKeyValue_(name) {
					if (!this.warnIfDisposed_(name)) {
						this.initStateKey_(name);
						return this.getStateInfo(name).value;
					}
				}

				/**
     * Merges the STATE static variable for the given constructor function.
     * @param  {!Function} ctor Constructor function.
     * @return {boolean} Returns true if merge happens, false otherwise.
     * @static
     */

			}, {
				key: 'hasBeenSet',

				/**
     * Checks if the value of the state key with the given name has already been
     * set. Note that this doesn't run the key's getter.
     * @param {string} name The name of the key.
     * @return {boolean}
     */
				value: function hasBeenSet(name) {
					var info = this.getStateInfo(name);
					return info.state === State.KeyStates.INITIALIZED || this.hasInitialValue_(name);
				}

				/**
     * Checks if an initial value was given to the specified state property.
     * @param {string} name The name of the key.
     * @return {boolean}
     * @protected
     */

			}, {
				key: 'hasInitialValue_',
				value: function hasInitialValue_(name) {
					return this.initialValues_.hasOwnProperty(name);
				}

				/**
     * Checks if the given key is present in this instance's state.
     * @param {string} key
     * @return {boolean}
     */

			}, {
				key: 'hasStateKey',
				value: function hasStateKey(key) {
					if (!this.warnIfDisposed_(key)) {
						return !!this.stateConfigs_[key];
					}
				}

				/**
     * Informs of changes to a state key's value through an event. Won't trigger
     * the event if the value hasn't changed or if it's being initialized.
     * @param {string} name The name of the key.
     * @param {*} prevVal The previous value of the key.
     * @protected
     */

			}, {
				key: 'informChange_',
				value: function informChange_(name, prevVal) {
					if (this.shouldInformChange_(name, prevVal)) {
						var data = _metal.object.mixin({
							key: name,
							newVal: this.get(name),
							prevVal: prevVal
						}, this.eventData_);
						this.context_.emit(name + 'Changed', data);
						this.context_.emit('stateKeyChanged', data);
						this.scheduleBatchEvent_(data);
					}
				}

				/**
     * Initializes the specified state key, giving it a first value.
     * @param {string} name The name of the key.
     * @protected
     */

			}, {
				key: 'initStateKey_',
				value: function initStateKey_(name) {
					var info = this.getStateInfo(name);
					if (info.state !== State.KeyStates.UNINITIALIZED) {
						return;
					}

					info.state = State.KeyStates.INITIALIZING;
					this.setInitialValue_(name);
					if (!info.written) {
						this.setDefaultValue(name);
					}
					info.state = State.KeyStates.INITIALIZED;
				}

				/**
     * Merges two values for the STATE property into a single object.
     * @param {Object} mergedVal
     * @param {Object} currVal
     * @return {!Object} The merged value.
     * @static
     */

			}, {
				key: 'removeStateKey',

				/**
     * Removes the requested state key.
     * @param {string} name The name of the key.
     */
				value: function removeStateKey(name) {
					this.stateInfo_[name] = null;
					this.stateConfigs_[name] = null;
					delete this.obj_[name];
				}

				/**
     * Schedules a state change batch event to be emitted asynchronously.
     * @param {!Object} changeData Information about a state key's update.
     * @protected
     */

			}, {
				key: 'scheduleBatchEvent_',
				value: function scheduleBatchEvent_(changeData) {
					if (!this.scheduledBatchData_) {
						_metal.async.nextTick(this.emitBatchEvent_, this);
						this.scheduledBatchData_ = _metal.object.mixin({
							changes: {}
						}, this.eventData_);
					}

					var name = changeData.key;
					var changes = this.scheduledBatchData_.changes;
					if (changes[name]) {
						changes[name].newVal = changeData.newVal;
					} else {
						changes[name] = changeData;
					}
				}

				/**
     * Sets the value of the requested state key.
     * Note: this can and should be accomplished by setting the state key as a
     * regular property. This should only be used in cases where a function is
     * actually needed.
     * @param {string} name
     * @param {*} value
     * @return {*}
     */

			}, {
				key: 'set',
				value: function set(name, value) {
					if (this.hasStateKey(name)) {
						this.obj_[name] = value;
					}
				}

				/**
     * Sets the default value of the requested state key.
     * @param {string} name The name of the key.
     * @return {*}
     */

			}, {
				key: 'setDefaultValue',
				value: function setDefaultValue(name) {
					var config = this.stateConfigs_[name];

					if (config.value !== undefined) {
						this.set(name, config.value);
					} else {
						this.set(name, this.callFunction_(config.valueFn));
					}
				}

				/**
     * Sets data to be sent with all events emitted from this instance.
     * @param {Object}
     */

			}, {
				key: 'setEventData',
				value: function setEventData(data) {
					this.eventData_ = data;
				}

				/**
     * Sets the initial value of the requested state key.
     * @param {string} name The name of the key.
     * @return {*}
     * @protected
     */

			}, {
				key: 'setInitialValue_',
				value: function setInitialValue_(name) {
					if (this.hasInitialValue_(name)) {
						this.set(name, this.initialValues_[name]);
						this.initialValues_[name] = undefined;
					}
				}

				/**
     * Sets a map of keys that are not valid state keys.
     * @param {!Object<string, boolean>}
     */

			}, {
				key: 'setKeysBlacklist',
				value: function setKeysBlacklist(blacklist) {
					this.keysBlacklist_ = blacklist;
				}

				/**
     * Sets the value of all the specified state keys.
     * @param {!Object.<string,*>} values A map of state keys to the values they
     *   should be set to.
     * @param {function()=} opt_callback An optional function that will be run
     *   after the next batched update is triggered.
     */

			}, {
				key: 'setState',
				value: function setState(values, opt_callback) {
					var _this2 = this;

					Object.keys(values).forEach(function (name) {
						return _this2.set(name, values[name]);
					});
					if (opt_callback && this.scheduledBatchData_) {
						this.context_.once('stateChanged', opt_callback);
					}
				}

				/**
     * Sets the value of the specified state key. This is passed as that key's
     * setter to the `Object.defineProperty` call inside the `addKeyToState`
     * method.
     * @param {string} name The name of the key.
     * @param {*} value The new value of the key.
     * @protected
     */

			}, {
				key: 'setStateKeyValue_',
				value: function setStateKeyValue_(name, value) {
					if (this.warnIfDisposed_(name) || !this.canSetState(name) || !this.validateKeyValue_(name, value)) {
						return;
					}

					var prevVal = this.get(name);
					var info = this.getStateInfo(name);
					info.value = this.callSetter_(name, value, prevVal);
					this.assertGivenIfRequired_(name);
					info.written = true;
					this.informChange_(name, prevVal);
				}

				/**
     * Checks if we should inform about a state update. Updates are ignored during
     * state initialization. Otherwise, updates to primitive values are only
     * informed when the new value is different from the previous one. Updates to
     * objects (which includes functions and arrays) are always informed outside
     * initialization though, since we can't be sure if all of the internal data
     * has stayed the same.
     * @param {string} name The name of the key.
     * @param {*} prevVal The previous value of the key.
     * @return {boolean}
     * @protected
     */

			}, {
				key: 'shouldInformChange_',
				value: function shouldInformChange_(name, prevVal) {
					var info = this.getStateInfo(name);
					return info.state === State.KeyStates.INITIALIZED && ((0, _metal.isObject)(prevVal) || prevVal !== this.get(name));
				}

				/**
     * Returns a boolean that determines whether or not should throw error when
     * vaildator functions returns an `Error` instance.
     * @return {boolean} By default returns false.
     */

			}, {
				key: 'shouldThrowValidationError',
				value: function shouldThrowValidationError() {
					return false;
				}

				/**
     * Validates the initial value for the state property with the given name.
     * @param {string} name
     * @protected
     */

			}, {
				key: 'validateInitialValue_',
				value: function validateInitialValue_(name) {
					if (this.hasInitialValue_(name) && !this.callValidator_(name, this.initialValues_[name])) {
						delete this.initialValues_[name];
					}
				}

				/**
     * Validates the state key's value, which includes calling the validator
     * defined in the key's configuration object, if there is one.
     * @param {string} name The name of the key.
     * @param {*} value The value to be validated.
     * @return {boolean} Flag indicating if value is valid or not.
     * @protected
     */

			}, {
				key: 'validateKeyValue_',
				value: function validateKeyValue_(name, value) {
					var info = this.getStateInfo(name);
					return info.state === State.KeyStates.INITIALIZING || this.callValidator_(name, value);
				}

				/**
     * Warns if this instance has already been disposed.
     * @param {string} name Name of the property to be accessed if not disposed.
     * @return {boolean} True if disposed, or false otherwise.
     * @protected
     */

			}, {
				key: 'warnIfDisposed_',
				value: function warnIfDisposed_(name) {
					var disposed = this.isDisposed();
					if (disposed) {
						console.warn('Error. Trying to access property "' + name + '" on disposed instance');
					}
					return disposed;
				}
			}], [{
				key: 'getStateStatic',
				value: function getStateStatic(ctor) {
					return (0, _metal.getStaticProperty)(ctor, 'STATE', State.mergeState);
				}
			}, {
				key: 'mergeState',
				value: function mergeState(mergedVal, currVal) {
					return _metal.object.mixin({}, currVal, mergedVal);
				}
			}]);

			return State;
		}(_metalEvents.EventEmitter);

		State.STATE_REF_KEY = '__METAL_STATE_REF_KEY__';

		/**
   * Constants that represent the states that a state key can be in.
   * @type {!Object}
   */
		State.KeyStates = {
			UNINITIALIZED: undefined,
			INITIALIZING: 1,
			INITIALIZED: 2
		};

		exports.default = State;
	}
});
//# sourceMappingURL=State.js.map