Liferay.Loader.define('frontend-js-metal-web$metal-router@3.6.3/build/amd/metal-promise/src/promise/Promise', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    define(['exports', 'metal/src/metal'], function (exports, _metal) {
      /*!
       * Promises polyfill from Google's Closure Library.
       *
       *      Copyright 2013 The Closure Library Authors. All Rights Reserved.
       *
       * NOTE(eduardo): Promise support is not ready on all supported browsers,
       * therefore metal-promise is temporarily using Google's promises as polyfill.
       * It supports cancellable promises and has clean and fast implementation.
       */

      'use strict';

      Object.defineProperty(exports, "__esModule", {
        value: true
      });
      exports.CancellablePromise = undefined;

      function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
          throw new TypeError("Cannot call a class as a function");
        }
      }

      function _possibleConstructorReturn(self, call) {
        if (!self) {
          throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
      }

      function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
          throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
          constructor: {
            value: subClass,
            enumerable: false,
            writable: true,
            configurable: true
          }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
      }

      /**
       * Provides a more strict interface for Thenables in terms of
       * http://promisesaplus.com for interop with {@see CancellablePromise}.
       *
       * @interface
       * @extends {IThenable.<TYPE>}
       * @template TYPE
       */
      var Thenable = function Thenable() {};

      /**
       * Adds callbacks that will operate on the result of the Thenable, returning a
       * new child Promise.
       *
       * If the Thenable is fulfilled, the {@code onFulfilled} callback will be
       * invoked with the fulfillment value as argument, and the child Promise will
       * be fulfilled with the return value of the callback. If the callback throws
       * an exception, the child Promise will be rejected with the thrown value
       * instead.
       *
       * If the Thenable is rejected, the {@code onRejected} callback will be invoked
       * with the rejection reason as argument, and the child Promise will be rejected
       * with the return value of the callback or thrown value.
       *
       * @param {?(function(this:THIS, TYPE):
       *             (RESULT|IThenable.<RESULT>|Thenable))=} opt_onFulfilled A
       *     function that will be invoked with the fulfillment value if the Promise
       *     is fullfilled.
       * @param {?(function(*): *)=} opt_onRejected A function that will be invoked
       *     with the rejection reason if the Promise is rejected.
       * @param {THIS=} opt_context An optional context object that will be the
       *     execution context for the callbacks. By default, functions are executed
       *     with the default this.
       * @return {!CancellablePromise.<RESULT>} A new Promise that will receive the
       *     result of the fulfillment or rejection callback.
       * @template RESULT,THIS
       */
      Thenable.prototype.then = function () {};

      /**
       * An expando property to indicate that an object implements
       * {@code Thenable}.
       *
       * {@see addImplementation}.
       *
       * @const
       */
      Thenable.IMPLEMENTED_BY_PROP = '$goog_Thenable';

      /**
       * Marks a given class (constructor) as an implementation of Thenable, so
       * that we can query that fact at runtime. The class must have already
       * implemented the interface.
       * Exports a 'then' method on the constructor prototype, so that the objects
       * also implement the extern {@see Thenable} interface for interop with
       * other Promise implementations.
       * @param {function(new:Thenable,...[?])} ctor The class constructor. The
       *     corresponding class must have already implemented the interface.
       */
      Thenable.addImplementation = function (ctor) {
        ctor.prototype.then = ctor.prototype.then;
        ctor.prototype.$goog_Thenable = true;
      };

      /**
       * @param {*} object
       * @return {boolean} Whether a given instance implements {@code Thenable}.
       *     The class/superclass of the instance must call {@code addImplementation}.
       */
      Thenable.isImplementedBy = function (object) {
        if (!object) {
          return false;
        }
        try {
          return !!object.$goog_Thenable;
        } catch (e) {
          // Property access seems to be forbidden.
          return false;
        }
      };

      /**
       * Like bind(), except that a 'this object' is not required. Useful when the
       * target function is already bound.
       *
       * Usage:
       * var g = partial(f, arg1, arg2);
       * g(arg3, arg4);
       *
       * @param {Function} fn A function to partially apply.
       * @param {...*} var_args Additional arguments that are partially applied to fn.
       * @return {!Function} A partially-applied form of the function bind() was
       *     invoked as a method of.
       */
      var partial = function partial(fn) {
        var args = Array.prototype.slice.call(arguments, 1);
        return function () {
          // Clone the array (with slice()) and append additional arguments
          // to the existing arguments.
          var newArgs = args.slice();
          newArgs.push.apply(newArgs, arguments);
          return fn.apply(this, newArgs);
        };
      };

      /**
       * Promises provide a result that may be resolved asynchronously. A Promise may
       * be resolved by being fulfilled or rejected with a value, which will be known
       * as the fulfillment value or the rejection reason. Whether fulfilled or
       * rejected, the Promise result is immutable once it is set.
       *
       * Promises may represent results of any type, including undefined. Rejection
       * reasons are typically Errors, but may also be of any type. Closure Promises
       * allow for optional type annotations that enforce that fulfillment values are
       * of the appropriate types at compile time.
       *
       * The result of a Promise is accessible by calling {@code then} and registering
       * {@code onFulfilled} and {@code onRejected} callbacks. Once the Promise
       * resolves, the relevant callbacks are invoked with the fulfillment value or
       * rejection reason as argument. Callbacks are always invoked in the order they
       * were registered, even when additional {@code then} calls are made from inside
       * another callback. A callback is always run asynchronously sometime after the
       * scope containing the registering {@code then} invocation has returned.
       *
       * If a Promise is resolved with another Promise, the first Promise will block
       * until the second is resolved, and then assumes the same result as the second
       * Promise. This allows Promises to depend on the results of other Promises,
       * linking together multiple asynchronous operations.
       *
       * This implementation is compatible with the Promises/A+ specification and
       * passes that specification's conformance test suite. A Closure Promise may be
       * resolved with a Promise instance (or sufficiently compatible Promise-like
       * object) created by other Promise implementations. From the specification,
       * Promise-like objects are known as "Thenables".
       *
       * @see http://promisesaplus.com/
       *
       * @param {function(
       *             this:RESOLVER_CONTEXT,
       *             function((TYPE|IThenable.<TYPE>|Thenable)),
       *             function(*)): void} resolver
       *     Initialization function that is invoked immediately with {@code resolve}
       *     and {@code reject} functions as arguments. The Promise is resolved or
       *     rejected with the first argument passed to either function.
       * @param {RESOLVER_CONTEXT=} opt_context An optional context for executing the
       *     resolver function. If unspecified, the resolver function will be executed
       *     in the default scope.
       * @constructor
       * @struct
       * @final
       * @implements {Thenable.<TYPE>}
       * @template TYPE,RESOLVER_CONTEXT
       */
      var CancellablePromise = function CancellablePromise(resolver, opt_context) {
        /**
         * The internal state of this Promise. Either PENDING, FULFILLED, REJECTED, or
         * BLOCKED.
         * @private {CancellablePromise.State_}
         */
        this.state_ = CancellablePromise.State_.PENDING;

        /**
         * The resolved result of the Promise. Immutable once set with either a
         * fulfillment value or rejection reason.
         * @private {*}
         */
        this.result_ = undefined;

        /**
         * For Promises created by calling {@code then()}, the originating parent.
         * @private {CancellablePromise}
         */
        this.parent_ = null;

        /**
         * The list of {@code onFulfilled} and {@code onRejected} callbacks added to
         * this Promise by calls to {@code then()}.
         * @private {Array.<CancellablePromise.CallbackEntry_>}
         */
        this.callbackEntries_ = null;

        /**
         * Whether the Promise is in the queue of Promises to execute.
         * @private {boolean}
         */
        this.executing_ = false;

        if (CancellablePromise.UNHANDLED_REJECTION_DELAY > 0) {
          /**
           * A timeout ID used when the {@code UNHANDLED_REJECTION_DELAY} is greater
           * than 0 milliseconds. The ID is set when the Promise is rejected, and
           * cleared only if an {@code onRejected} callback is invoked for the
           * Promise (or one of its descendants) before the delay is exceeded.
           *
           * If the rejection is not handled before the timeout completes, the
           * rejection reason is passed to the unhandled rejection handler.
           * @private {number}
           */
          this.unhandledRejectionId_ = 0;
        } else if (CancellablePromise.UNHANDLED_REJECTION_DELAY === 0) {
          /**
           * When the {@code UNHANDLED_REJECTION_DELAY} is set to 0 milliseconds, a
           * boolean that is set if the Promise is rejected, and reset to false if an
           * {@code onRejected} callback is invoked for the Promise (or one of its
           * descendants). If the rejection is not handled before the next timestep,
           * the rejection reason is passed to the unhandled rejection handler.
           * @private {boolean}
           */
          this.hadUnhandledRejection_ = false;
        }

        try {
          var self = this;
          resolver.call(opt_context, function (value) {
            self.resolve_(CancellablePromise.State_.FULFILLED, value);
          }, function (reason) {
            self.resolve_(CancellablePromise.State_.REJECTED, reason);
          });
        } catch (e) {
          this.resolve_(CancellablePromise.State_.REJECTED, e);
        }
      };

      /**
       * The delay in milliseconds before a rejected Promise's reason is passed to
       * the rejection handler. By default, the rejection handler rethrows the
       * rejection reason so that it appears in the developer console or
       * {@code window.onerror} handler.
       * Rejections are rethrown as quickly as possible by default. A negative value
       * disables rejection handling entirely.
       * @type {number}
       */
      CancellablePromise.UNHANDLED_REJECTION_DELAY = 0;

      /**
       * The possible internal states for a Promise. These states are not directly
       * observable to external callers.
       * @enum {number}
       * @private
       */
      CancellablePromise.State_ = {
        /** The Promise is waiting for resolution. */
        PENDING: 0,

        /** The Promise is blocked waiting for the result of another Thenable. */
        BLOCKED: 1,

        /** The Promise has been resolved with a fulfillment value. */
        FULFILLED: 2,

        /** The Promise has been resolved with a rejection reason. */
        REJECTED: 3
      };

      /**
       * Typedef for entries in the callback chain. Each call to {@code then},
       * {@code thenCatch}, or {@code thenAlways} creates an entry containing the
       * functions that may be invoked once the Promise is resolved.
       *
       * @typedef {{
       *   child: CancellablePromise,
       *   onFulfilled: function(*),
       *   onRejected: function(*)
       * }}
       * @private
       */
      CancellablePromise.CallbackEntry_ = null;

      /**
       * @param {(TYPE|Thenable.<TYPE>|Thenable)=} opt_value
       * @return {!CancellablePromise.<TYPE>} A new Promise that is immediately resolved
       *     with the given value.
       * @template TYPE
       */
      CancellablePromise.resolve = function (opt_value) {
        return new CancellablePromise(function (resolve) {
          resolve(opt_value);
        });
      };

      /**
       * @param {*=} opt_reason
       * @return {!CancellablePromise} A new Promise that is immediately rejected with the
       *     given reason.
       */
      CancellablePromise.reject = function (opt_reason) {
        return new CancellablePromise(function (resolve, reject) {
          reject(opt_reason);
        });
      };

      /**
       * @param {!Array.<!(Thenable.<TYPE>|Thenable)>} promises
       * @return {!CancellablePromise.<TYPE>} A Promise that receives the result of the
       *     first Promise (or Promise-like) input to complete.
       * @template TYPE
       */
      CancellablePromise.race = function (promises) {
        return new CancellablePromise(function (resolve, reject) {
          if (!promises.length) {
            resolve(undefined);
          }
          for (var i = 0, promise; promise = promises[i]; i++) {
            promise.then(resolve, reject);
          }
        });
      };

      /**
       * @param {!Array.<!(Thenable.<TYPE>|Thenable)>} promises
       * @return {!CancellablePromise.<!Array.<TYPE>>} A Promise that receives a list of
       *     every fulfilled value once every input Promise (or Promise-like) is
       *     successfully fulfilled, or is rejected by the first rejection result.
       * @template TYPE
       */
      CancellablePromise.all = function (promises) {
        return new CancellablePromise(function (resolve, reject) {
          var toFulfill = promises.length;
          var values = [];

          if (!toFulfill) {
            resolve(values);
            return;
          }

          var onFulfill = function onFulfill(index, value) {
            toFulfill--;
            values[index] = value;
            if (toFulfill === 0) {
              resolve(values);
            }
          };

          var onReject = function onReject(reason) {
            reject(reason);
          };

          for (var i = 0, promise; promise = promises[i]; i++) {
            promise.then(partial(onFulfill, i), onReject);
          }
        });
      };

      /**
       * @param {!Array.<!(Thenable.<TYPE>|Thenable)>} promises
       * @return {!CancellablePromise.<TYPE>} A Promise that receives the value of
       *     the first input to be fulfilled, or is rejected with a list of every
       *     rejection reason if all inputs are rejected.
       * @template TYPE
       */
      CancellablePromise.firstFulfilled = function (promises) {
        return new CancellablePromise(function (resolve, reject) {
          var toReject = promises.length;
          var reasons = [];

          if (!toReject) {
            resolve(undefined);
            return;
          }

          var onFulfill = function onFulfill(value) {
            resolve(value);
          };

          var onReject = function onReject(index, reason) {
            toReject--;
            reasons[index] = reason;
            if (toReject === 0) {
              reject(reasons);
            }
          };

          for (var i = 0, promise; promise = promises[i]; i++) {
            promise.then(onFulfill, partial(onReject, i));
          }
        });
      };

      /**
       * Adds callbacks that will operate on the result of the Promise, returning a
       * new child Promise.
       *
       * If the Promise is fulfilled, the {@code onFulfilled} callback will be invoked
       * with the fulfillment value as argument, and the child Promise will be
       * fulfilled with the return value of the callback. If the callback throws an
       * exception, the child Promise will be rejected with the thrown value instead.
       *
       * If the Promise is rejected, the {@code onRejected} callback will be invoked
       * with the rejection reason as argument, and the child Promise will be rejected
       * with the return value (or thrown value) of the callback.
       *
       * @override
       */
      CancellablePromise.prototype.then = function (opt_onFulfilled, opt_onRejected, opt_context) {
        return this.addChildPromise_((0, _metal.isFunction)(opt_onFulfilled) ? opt_onFulfilled : null, (0, _metal.isFunction)(opt_onRejected) ? opt_onRejected : null, opt_context);
      };
      Thenable.addImplementation(CancellablePromise);

      /**
       * Adds a callback that will be invoked whether the Promise is fulfilled or
       * rejected. The callback receives no argument, and no new child Promise is
       * created. This is useful for ensuring that cleanup takes place after certain
       * asynchronous operations. Callbacks added with {@code thenAlways} will be
       * executed in the same order with other calls to {@code then},
       * {@code thenAlways}, or {@code thenCatch}.
       *
       * Since it does not produce a new child Promise, cancellation propagation is
       * not prevented by adding callbacks with {@code thenAlways}. A Promise that has
       * a cleanup handler added with {@code thenAlways} will be canceled if all of
       * its children created by {@code then} (or {@code thenCatch}) are canceled.
       *
       * @param {function(this:THIS): void} onResolved A function that will be invoked
       *     when the Promise is resolved.
       * @param {THIS=} opt_context An optional context object that will be the
       *     execution context for the callbacks. By default, functions are executed
       *     in the global scope.
       * @return {!CancellablePromise.<TYPE>} This Promise, for chaining additional calls.
       * @template THIS
       */
      CancellablePromise.prototype.thenAlways = function (onResolved, opt_context) {
        var callback = function callback() {
          try {
            // Ensure that no arguments are passed to onResolved.
            onResolved.call(opt_context);
          } catch (err) {
            CancellablePromise.handleRejection_.call(null, err);
          }
        };

        this.addCallbackEntry_({
          child: null,
          onRejected: callback,
          onFulfilled: callback
        });
        return this;
      };

      /**
       * Adds a callback that will be invoked only if the Promise is rejected. This
       * is equivalent to {@code then(null, onRejected)}.
       *
       * @param {!function(this:THIS, *): *} onRejected A function that will be
       *     invoked with the rejection reason if the Promise is rejected.
       * @param {THIS=} opt_context An optional context object that will be the
       *     execution context for the callbacks. By default, functions are executed
       *     in the global scope.
       * @return {!CancellablePromise} A new Promise that will receive the result of the
       *     callback.
       * @template THIS
       */
      CancellablePromise.prototype.thenCatch = function (onRejected, opt_context) {
        return this.addChildPromise_(null, onRejected, opt_context);
      };

      /**
       * Alias of {@link CancellablePromise.prototype.thenCatch}
       */
      CancellablePromise.prototype.catch = CancellablePromise.prototype.thenCatch;

      /**
       * Cancels the Promise if it is still pending by rejecting it with a cancel
       * Error. No action is performed if the Promise is already resolved.
       *
       * All child Promises of the canceled Promise will be rejected with the same
       * cancel error, as with normal Promise rejection. If the Promise to be canceled
       * is the only child of a pending Promise, the parent Promise will also be
       * canceled. Cancellation may propagate upward through multiple generations.
       *
       * @param {string=} opt_message An optional debugging message for describing the
       *     cancellation reason.
       */
      CancellablePromise.prototype.cancel = function (opt_message) {
        if (this.state_ === CancellablePromise.State_.PENDING) {
          _metal.async.run(function () {
            var err = new CancellablePromise.CancellationError(opt_message);
            err.IS_CANCELLATION_ERROR = true;
            this.cancelInternal_(err);
          }, this);
        }
      };

      /**
       * Cancels this Promise with the given error.
       *
       * @param {!Error} err The cancellation error.
       * @private
       */
      CancellablePromise.prototype.cancelInternal_ = function (err) {
        if (this.state_ === CancellablePromise.State_.PENDING) {
          if (this.parent_) {
            // Cancel the Promise and remove it from the parent's child list.
            this.parent_.cancelChild_(this, err);
          } else {
            this.resolve_(CancellablePromise.State_.REJECTED, err);
          }
        }
      };

      /**
       * Cancels a child Promise from the list of callback entries. If the Promise has
       * not already been resolved, reject it with a cancel error. If there are no
       * other children in the list of callback entries, propagate the cancellation
       * by canceling this Promise as well.
       *
       * @param {!CancellablePromise} childPromise The Promise to cancel.
       * @param {!Error} err The cancel error to use for rejecting the Promise.
       * @private
       */
      CancellablePromise.prototype.cancelChild_ = function (childPromise, err) {
        if (!this.callbackEntries_) {
          return;
        }
        var childCount = 0;
        var childIndex = -1;

        // Find the callback entry for the childPromise, and count whether there are
        // additional child Promises.
        for (var i = 0, entry; entry = this.callbackEntries_[i]; i++) {
          var child = entry.child;
          if (child) {
            childCount++;
            if (child === childPromise) {
              childIndex = i;
            }
            if (childIndex >= 0 && childCount > 1) {
              break;
            }
          }
        }

        // If the child Promise was the only child, cancel this Promise as well.
        // Otherwise, reject only the child Promise with the cancel error.
        if (childIndex >= 0) {
          if (this.state_ === CancellablePromise.State_.PENDING && childCount === 1) {
            this.cancelInternal_(err);
          } else {
            var callbackEntry = this.callbackEntries_.splice(childIndex, 1)[0];
            this.executeCallback_(callbackEntry, CancellablePromise.State_.REJECTED, err);
          }
        }
      };

      /**
       * Adds a callback entry to the current Promise, and schedules callback
       * execution if the Promise has already been resolved.
       *
       * @param {CancellablePromise.CallbackEntry_} callbackEntry Record containing
       *     {@code onFulfilled} and {@code onRejected} callbacks to execute after
       *     the Promise is resolved.
       * @private
       */
      CancellablePromise.prototype.addCallbackEntry_ = function (callbackEntry) {
        if ((!this.callbackEntries_ || !this.callbackEntries_.length) && (this.state_ === CancellablePromise.State_.FULFILLED || this.state_ === CancellablePromise.State_.REJECTED)) {
          this.scheduleCallbacks_();
        }
        if (!this.callbackEntries_) {
          this.callbackEntries_ = [];
        }
        this.callbackEntries_.push(callbackEntry);
      };

      /**
       * Creates a child Promise and adds it to the callback entry list. The result of
       * the child Promise is determined by the state of the parent Promise and the
       * result of the {@code onFulfilled} or {@code onRejected} callbacks as
       * specified in the Promise resolution procedure.
       *
       * @see http://promisesaplus.com/#the__method
       *
       * @param {?function(this:THIS, TYPE):
       *          (RESULT|CancellablePromise.<RESULT>|Thenable)} onFulfilled A callback that
       *     will be invoked if the Promise is fullfilled, or null.
       * @param {?function(this:THIS, *): *} onRejected A callback that will be
       *     invoked if the Promise is rejected, or null.
       * @param {THIS=} opt_context An optional execution context for the callbacks.
       *     in the default calling context.
       * @return {!CancellablePromise} The child Promise.
       * @template RESULT,THIS
       * @private
       */
      CancellablePromise.prototype.addChildPromise_ = function (onFulfilled, onRejected, opt_context) {

        var callbackEntry = {
          child: null,
          onFulfilled: null,
          onRejected: null
        };

        callbackEntry.child = new CancellablePromise(function (resolve, reject) {
          // Invoke onFulfilled, or resolve with the parent's value if absent.
          callbackEntry.onFulfilled = onFulfilled ? function (value) {
            try {
              var result = onFulfilled.call(opt_context, value);
              resolve(result);
            } catch (err) {
              reject(err);
            }
          } : resolve;

          // Invoke onRejected, or reject with the parent's reason if absent.
          callbackEntry.onRejected = onRejected ? function (reason) {
            try {
              var result = onRejected.call(opt_context, reason);
              if (!(0, _metal.isDef)(result) && reason.IS_CANCELLATION_ERROR) {
                // Propagate cancellation to children if no other result is returned.
                reject(reason);
              } else {
                resolve(result);
              }
            } catch (err) {
              reject(err);
            }
          } : reject;
        });

        callbackEntry.child.parent_ = this;
        this.addCallbackEntry_(
        /** @type {CancellablePromise.CallbackEntry_} */callbackEntry);
        return callbackEntry.child;
      };

      /**
       * Unblocks the Promise and fulfills it with the given value.
       *
       * @param {TYPE} value
       * @private
       */
      CancellablePromise.prototype.unblockAndFulfill_ = function (value) {
        if (this.state_ !== CancellablePromise.State_.BLOCKED) {
          throw new Error('CancellablePromise is not blocked.');
        }
        this.state_ = CancellablePromise.State_.PENDING;
        this.resolve_(CancellablePromise.State_.FULFILLED, value);
      };

      /**
       * Unblocks the Promise and rejects it with the given rejection reason.
       *
       * @param {*} reason
       * @private
       */
      CancellablePromise.prototype.unblockAndReject_ = function (reason) {
        if (this.state_ !== CancellablePromise.State_.BLOCKED) {
          throw new Error('CancellablePromise is not blocked.');
        }
        this.state_ = CancellablePromise.State_.PENDING;
        this.resolve_(CancellablePromise.State_.REJECTED, reason);
      };

      /**
       * Attempts to resolve a Promise with a given resolution state and value. This
       * is a no-op if the given Promise has already been resolved.
       *
       * If the given result is a Thenable (such as another Promise), the Promise will
       * be resolved with the same state and result as the Thenable once it is itself
       * resolved.
       *
       * If the given result is not a Thenable, the Promise will be fulfilled or
       * rejected with that result based on the given state.
       *
       * @see http://promisesaplus.com/#the_promise_resolution_procedure
       *
       * @param {CancellablePromise.State_} state
       * @param {*} x The result to apply to the Promise.
       * @private
       */
      CancellablePromise.prototype.resolve_ = function (state, x) {
        if (this.state_ !== CancellablePromise.State_.PENDING) {
          return;
        }

        if (this === x) {
          state = CancellablePromise.State_.REJECTED;
          x = new TypeError('CancellablePromise cannot resolve to itself');
        } else if (Thenable.isImplementedBy(x)) {
          x = /** @type {!Thenable} */x;
          this.state_ = CancellablePromise.State_.BLOCKED;
          x.then(this.unblockAndFulfill_, this.unblockAndReject_, this);
          return;
        } else if ((0, _metal.isObject)(x)) {
          try {
            var then = x.then;
            if ((0, _metal.isFunction)(then)) {
              this.tryThen_(x, then);
              return;
            }
          } catch (e) {
            state = CancellablePromise.State_.REJECTED;
            x = e;
          }
        }

        this.result_ = x;
        this.state_ = state;
        this.scheduleCallbacks_();

        if (state === CancellablePromise.State_.REJECTED && !x.IS_CANCELLATION_ERROR) {
          CancellablePromise.addUnhandledRejection_(this, x);
        }
      };

      /**
       * Attempts to call the {@code then} method on an object in the hopes that it is
       * a Promise-compatible instance. This allows interoperation between different
       * Promise implementations, however a non-compliant object may cause a Promise
       * to hang indefinitely. If the {@code then} method throws an exception, the
       * dependent Promise will be rejected with the thrown value.
       *
       * @see http://promisesaplus.com/#point-70
       *
       * @param {Thenable} thenable An object with a {@code then} method that may be
       *     compatible with the Promise/A+ specification.
       * @param {!Function} then The {@code then} method of the Thenable object.
       * @private
       */
      CancellablePromise.prototype.tryThen_ = function (thenable, then) {
        this.state_ = CancellablePromise.State_.BLOCKED;
        var promise = this;
        var called = false;

        var resolve = function resolve(value) {
          if (!called) {
            called = true;
            promise.unblockAndFulfill_(value);
          }
        };

        var reject = function reject(reason) {
          if (!called) {
            called = true;
            promise.unblockAndReject_(reason);
          }
        };

        try {
          then.call(thenable, resolve, reject);
        } catch (e) {
          reject(e);
        }
      };

      /**
       * Executes the pending callbacks of a resolved Promise after a timeout.
       *
       * Section 2.2.4 of the Promises/A+ specification requires that Promise
       * callbacks must only be invoked from a call stack that only contains Promise
       * implementation code, which we accomplish by invoking callback execution after
       * a timeout. If {@code startExecution_} is called multiple times for the same
       * Promise, the callback chain will be evaluated only once. Additional callbacks
       * may be added during the evaluation phase, and will be executed in the same
       * event loop.
       *
       * All Promises added to the waiting list during the same browser event loop
       * will be executed in one batch to avoid using a separate timeout per Promise.
       *
       * @private
       */
      CancellablePromise.prototype.scheduleCallbacks_ = function () {
        if (!this.executing_) {
          this.executing_ = true;
          _metal.async.run(this.executeCallbacks_, this);
        }
      };

      /**
       * Executes all pending callbacks for this Promise.
       *
       * @private
       */
      CancellablePromise.prototype.executeCallbacks_ = function () {
        while (this.callbackEntries_ && this.callbackEntries_.length) {
          var entries = this.callbackEntries_;
          this.callbackEntries_ = [];

          for (var i = 0; i < entries.length; i++) {
            this.executeCallback_(entries[i], this.state_, this.result_);
          }
        }
        this.executing_ = false;
      };

      /**
       * Executes a pending callback for this Promise. Invokes an {@code onFulfilled}
       * or {@code onRejected} callback based on the resolved state of the Promise.
       *
       * @param {!CancellablePromise.CallbackEntry_} callbackEntry An entry containing the
       *     onFulfilled and/or onRejected callbacks for this step.
       * @param {CancellablePromise.State_} state The resolution status of the Promise,
       *     either FULFILLED or REJECTED.
       * @param {*} result The resolved result of the Promise.
       * @private
       */
      CancellablePromise.prototype.executeCallback_ = function (callbackEntry, state, result) {
        if (state === CancellablePromise.State_.FULFILLED) {
          callbackEntry.onFulfilled(result);
        } else {
          this.removeUnhandledRejection_();
          callbackEntry.onRejected(result);
        }
      };

      /**
       * Marks this rejected Promise as having being handled. Also marks any parent
       * Promises in the rejected state as handled. The rejection handler will no
       * longer be invoked for this Promise (if it has not been called already).
       *
       * @private
       */
      CancellablePromise.prototype.removeUnhandledRejection_ = function () {
        var p;
        if (CancellablePromise.UNHANDLED_REJECTION_DELAY > 0) {
          for (p = this; p && p.unhandledRejectionId_; p = p.parent_) {
            clearTimeout(p.unhandledRejectionId_);
            p.unhandledRejectionId_ = 0;
          }
        } else if (CancellablePromise.UNHANDLED_REJECTION_DELAY === 0) {
          for (p = this; p && p.hadUnhandledRejection_; p = p.parent_) {
            p.hadUnhandledRejection_ = false;
          }
        }
      };

      /**
       * Marks this rejected Promise as unhandled. If no {@code onRejected} callback
       * is called for this Promise before the {@code UNHANDLED_REJECTION_DELAY}
       * expires, the reason will be passed to the unhandled rejection handler. The
       * handler typically rethrows the rejection reason so that it becomes visible in
       * the developer console.
       *
       * @param {!CancellablePromise} promise The rejected Promise.
       * @param {*} reason The Promise rejection reason.
       * @private
       */
      CancellablePromise.addUnhandledRejection_ = function (promise, reason) {
        if (CancellablePromise.UNHANDLED_REJECTION_DELAY > 0) {
          promise.unhandledRejectionId_ = setTimeout(function () {
            CancellablePromise.handleRejection_.call(null, reason);
          }, CancellablePromise.UNHANDLED_REJECTION_DELAY);
        } else if (CancellablePromise.UNHANDLED_REJECTION_DELAY === 0) {
          promise.hadUnhandledRejection_ = true;
          _metal.async.run(function () {
            if (promise.hadUnhandledRejection_) {
              CancellablePromise.handleRejection_.call(null, reason);
            }
          });
        }
      };

      /**
       * A method that is invoked with the rejection reasons for Promises that are
       * rejected but have no {@code onRejected} callbacks registered yet.
       * @type {function(*)}
       * @private
       */
      CancellablePromise.handleRejection_ = _metal.async.throwException;

      /**
       * Sets a handler that will be called with reasons from unhandled rejected
       * Promises. If the rejected Promise (or one of its descendants) has an
       * {@code onRejected} callback registered, the rejection will be considered
       * handled, and the rejection handler will not be called.
       *
       * By default, unhandled rejections are rethrown so that the error may be
       * captured by the developer console or a {@code window.onerror} handler.
       *
       * @param {function(*)} handler A function that will be called with reasons from
       *     rejected Promises. Defaults to {@code async.throwException}.
       */
      CancellablePromise.setUnhandledRejectionHandler = function (handler) {
        CancellablePromise.handleRejection_ = handler;
      };

      /**
       * Error used as a rejection reason for canceled Promises.
       *
       * @param {string=} opt_message
       * @constructor
       * @extends {Error}
       * @final
       */
      CancellablePromise.CancellationError = function (_Error) {
        _inherits(_class, _Error);

        function _class(opt_message) {
          _classCallCheck(this, _class);

          var _this = _possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this, opt_message));

          if (opt_message) {
            _this.message = opt_message;
          }
          return _this;
        }

        return _class;
      }(Error);

      /** @override */
      CancellablePromise.CancellationError.prototype.name = 'cancel';

      exports.CancellablePromise = CancellablePromise;
      exports.default = CancellablePromise;
    });
    //# sourceMappingURL=Promise.js.map
  }
});
//# sourceMappingURL=Promise.js.map