'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-pagination@2.0.1/lib/Pagination', ['module', 'exports', 'require', 'frontend-js-metal-web$metal', './Pagination.soy', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		Object.defineProperty(exports, "__esModule", {
			value: true
		});

		var _metal = require('frontend-js-metal-web$metal');

		var _PaginationSoy = require('./Pagination.soy');

		var _PaginationSoy2 = _interopRequireDefault(_PaginationSoy);

		var _metalComponent = require('frontend-js-metal-web$metal-component');

		var _metalComponent2 = _interopRequireDefault(_metalComponent);

		var _metalSoy = require('frontend-js-metal-web$metal-soy');

		var _metalSoy2 = _interopRequireDefault(_metalSoy);

		function _interopRequireDefault(obj) {
			return obj && obj.__esModule ? obj : { default: obj };
		}

		function _classCallCheck(instance, Constructor) {
			if (!(instance instanceof Constructor)) {
				throw new TypeError("Cannot call a class as a function");
			}
		}

		function _possibleConstructorReturn(self, call) {
			if (!self) {
				throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
			}return call && (typeof call === "object" || typeof call === "function") ? call : self;
		}

		function _inherits(subClass, superClass) {
			if (typeof superClass !== "function" && superClass !== null) {
				throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
			}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
		}

		/**
   * UI Component that navigate through paged data.
   */
		var Pagination = function (_Component) {
			_inherits(Pagination, _Component);

			function Pagination() {
				_classCallCheck(this, Pagination);

				return _possibleConstructorReturn(this, _Component.apply(this, arguments));
			}

			/**
    * @inheritDoc
    */
			Pagination.prototype.created = function created() {
				/**
     * Contains the previous page value
     * @type {Object}
     * @default {page: this.page}
     */
				this.lastState_ = {
					page: this.page
				};

				this.on(Pagination.Events.CHANGE_REQUEST, this.defaultChangeRequestFn_, true);
			};

			/**
    * Default `changeRequest` function, sets new state of pagination.
    * @param {EventFacade} event
    * @protected
    */

			Pagination.prototype.defaultChangeRequestFn_ = function defaultChangeRequestFn_(event) {
				this.setState_(event.state);
			};

			/**
    * Fires `changeRequest` event.
    * @param {Object} state
    * @protected
    */

			Pagination.prototype.dispatchRequest_ = function dispatchRequest_(state) {
				this.emit(Pagination.Events.CHANGE_REQUEST, {
					lastState: this.lastState_,
					offset: this.offset,
					state: state,
					total: this.total
				});
			};

			/**
    * Retrieve page number including offset e.g., if offset is 100 and
    * active page is 5, this method returns 105.
    * @return {number} current page number plus offset
    */

			Pagination.prototype.getOffsetPageNumber = function getOffsetPageNumber() {
				return this.offset + this.page;
			};

			/**
    * Retrieve total number of pages including offset e.g., if offset is
    * 100 and total 10, this method returns 110.
    * @return {number} total page number plus offset
    */

			Pagination.prototype.getOffsetTotalPages = function getOffsetTotalPages() {
				return this.offset + this.total;
			};

			/**
   * Navigate to the next page.
   */

			Pagination.prototype.next = function next() {
				var page = this.page,
				    total = this.total;

				this.dispatchRequest_({
					page: this.circular && page === total - 1 ? 0 : Math.min(total, ++page)
				});
			};

			/**
    * `onClick` handler for pagination items.
    * @param {EventFacade} event
    */

			Pagination.prototype.onClickItem = function onClickItem(event) {
				var item = event.delegateTarget;

				event.preventDefault();

				var index = parseInt(item.getAttribute('data-index'));

				this.dispatchRequest_({
					page: index
				});
			};

			/**
    * `onClick` handler for pagination items.
    * @param {EventFacade} event
    */

			Pagination.prototype.onClickControls = function onClickControls(event) {
				var control = event.delegateTarget;

				event.preventDefault();

				var index = parseInt(control.getAttribute('data-control-index'));

				switch (index) {
					case 0:
						this.prev();
						break;
					case 1:
						this.next();
						break;
				}
			};

			/**
    * Navigate to the previous page.
    */

			Pagination.prototype.prev = function prev() {
				var page = this.page,
				    total = this.total;

				this.dispatchRequest_({
					page: this.circular && page === 0 ? total - 1 : Math.max(0, --page)
				});
			};

			/**
    * Set the new pagination state. The state is a payload object
    * containing the page number, e.g. `{page:1}`.
    * @param {Object} state
    * @return {Object}
    * @protected
    */

			Pagination.prototype.setState_ = function setState_(state) {
				this.page = state.page;

				this.lastState_ = state;
			};

			return Pagination;
		}(_metalComponent2.default);

		_metalSoy2.default.register(Pagination, _PaginationSoy2.default);

		/**
   * State definition.
   * @type {!Object}
   * @static
   */
		Pagination.STATE = {
			/**
    * When enabled this property allows the navigation to go back to
    * the beggining when it reaches the last page, the opposite behavior
    * is also true. Incremental page navigation could happen clicking the
    * control arrows or invoking <code>.next()</code> and
    * <code>.prev()</code> methods.
    * @type {boolean}
    * @default true
    */
			circular: {
				validator: _metal.core.isBoolean,
				value: true
			},

			/**
    * Initial page offset.
    * @type {number}
    * @default 1
    */
			offset: {
				validator: _metal.core.isNumber,
				value: 1
			},

			/**
    * Page to display on initial paint.
    * @type {number}
    * @default 0
    */
			page: {
				validator: _metal.core.isNumber,
				value: 0
			},

			/**
    * Determines if pagination controls (Next and Prev) are rendered.
    * @type {boolean}
    * @default true
    */
			showControls: {
				validator: _metal.core.isBoolean,
				value: true
			},

			/**
    * Collection of strings used to label elements of the UI.
    * @type {Object}
    * @default {next: 'Next', prev: 'Prev'}
    */
			strings: {
				validator: _metal.core.isObject,
				setter: function setter(val) {
					return _metal.object.mixin({
						next: 'Next',
						nextAriaLabel: 'Next',
						prev: 'Prev',
						prevAriaLabel: 'Previous'
					}, val);
				},
				valueFn: function valueFn() {}
			},

			/**
    * Total number of page links available. If set, the new
    * <a href="Pagination.html#config_items">items</a> node list will
    * be rendered.
    * @type {number}
    * @default 0
    */
			total: {
				validator: _metal.core.isNumber,
				value: 0
			}
		};

		Pagination.Events = {
			CHANGE_REQUEST: 'changeRequest'
		};

		exports.default = Pagination;
	}
});
//# sourceMappingURL=Pagination.js.map