'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-key@1.0.0/lib/keyboardEvents', ['module', 'exports', 'require', 'frontend-js-metal-web$metal-dom', './keyConstants'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.KEYMAP = undefined;

    var _metalDom = require('frontend-js-metal-web$metal-dom');

    var _keyConstants = require('./keyConstants');

    var KEYMAP = _interopRequireWildcard(_keyConstants);

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      } else {
        var newObj = {};if (obj != null) {
          for (var key in obj) {
            if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key];
          }
        }newObj.default = obj;return newObj;
      }
    }

    /**
     * Creates a custom event configuration object to deal with keyboard events.
     * @param {!string} originalEvent The the original DOM event name.
     * @param {!string} keyAlias Name that represents the key code number.
     * @param {!number} keyCode The key code value.
     * @return {object} The custom keyboard event configuration that has all the
     *  necessary informations for the handler function.
     */
    function createCustomKeyboardEventConfig(originalEvent, keyAlias, keyCode) {
      return {
        event: true,
        delegate: true,
        key: keyCode,
        handler: function handler(callback, event) {
          if (this.key === event.keyCode) {
            event.customType = originalEvent + '-' + keyAlias;
            callback(event);
          }
        },
        originalEvent: originalEvent
      };
    }

    Object.keys(KEYMAP).forEach(function (key) {
      var keyAlias = key.toLowerCase();

      (0, _metalDom.registerCustomEvent)('keydown-' + keyAlias, createCustomKeyboardEventConfig('keydown', keyAlias, KEYMAP[key]));
      (0, _metalDom.registerCustomEvent)('keyup-' + keyAlias, createCustomKeyboardEventConfig('keyup', keyAlias, KEYMAP[key]));
      (0, _metalDom.registerCustomEvent)('keypress-' + keyAlias, createCustomKeyboardEventConfig('keypress', keyAlias, KEYMAP[key]));
    });

    exports.KEYMAP = KEYMAP;
  }
});
//# sourceMappingURL=keyboardEvents.js.map