'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-events@2.16.8/lib/EventHandle", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		Object.defineProperty(exports, "__esModule", {
			value: true
		});

		var _createClass = function () {
			function defineProperties(target, props) {
				for (var i = 0; i < props.length; i++) {
					var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
				}
			}return function (Constructor, protoProps, staticProps) {
				if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
			};
		}();

		var _metal = require("frontend-js-metal-web$metal");

		function _classCallCheck(instance, Constructor) {
			if (!(instance instanceof Constructor)) {
				throw new TypeError("Cannot call a class as a function");
			}
		}

		function _possibleConstructorReturn(self, call) {
			if (!self) {
				throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
			}return call && (typeof call === "object" || typeof call === "function") ? call : self;
		}

		function _inherits(subClass, superClass) {
			if (typeof superClass !== "function" && superClass !== null) {
				throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
			}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
		}

		/**
   * EventHandle utility. Holds information about an event subscription, and
   * allows removing them easily.
   * EventHandle is a Disposable, but it's important to note that the
   * EventEmitter that created it is not the one responsible for disposing it.
   * That responsibility is for the code that holds a reference to it.
   * @extends {Disposable}
   */
		var EventHandle = function (_Disposable) {
			_inherits(EventHandle, _Disposable);

			/**
    * EventHandle constructor
    * @param {!EventEmitter} emitter Emitter the event was subscribed to.
    * @param {string} event The name of the event that was subscribed to.
    * @param {!Function} listener The listener subscribed to the event.
    */
			function EventHandle(emitter, event, listener) {
				_classCallCheck(this, EventHandle);

				/**
     * The EventEmitter instance that the event was subscribed to.
     * @type {EventEmitter}
     * @protected
     */
				var _this = _possibleConstructorReturn(this, (EventHandle.__proto__ || Object.getPrototypeOf(EventHandle)).call(this));

				_this.emitter_ = emitter;

				/**
     * The name of the event that was subscribed to.
     * @type {string}
     * @protected
     */
				_this.event_ = event;

				/**
     * The listener subscribed to the event.
     * @type {Function}
     * @protected
     */
				_this.listener_ = listener;
				return _this;
			}

			/**
    * Disposes of this instance's object references.
    * @override
    */

			_createClass(EventHandle, [{
				key: 'disposeInternal',
				value: function disposeInternal() {
					this.removeListener();
					this.emitter_ = null;
					this.listener_ = null;
				}

				/**
     * Removes the listener subscription from the emitter.
     */

			}, {
				key: 'removeListener',
				value: function removeListener() {
					if (!this.emitter_.isDisposed()) {
						this.emitter_.removeListener(this.event_, this.listener_);
					}
				}
			}]);

			return EventHandle;
		}(_metal.Disposable);

		exports.default = EventHandle;
		//# sourceMappingURL=EventHandle.js.map
	}
});
//# sourceMappingURL=EventHandle.js.map