'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-drag-drop@3.3.1/lib/DragDrop", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', './Drag', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		Object.defineProperty(exports, "__esModule", {
			value: true
		});
		exports.Drag = exports.DragDrop = undefined;

		var _createClass = function () {
			function defineProperties(target, props) {
				for (var i = 0; i < props.length; i++) {
					var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
				}
			}return function (Constructor, protoProps, staticProps) {
				if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
			};
		}();

		var _get = function get(object, property, receiver) {
			if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
				var parent = Object.getPrototypeOf(object);if (parent === null) {
					return undefined;
				} else {
					return get(parent, property, receiver);
				}
			} else if ("value" in desc) {
				return desc.value;
			} else {
				var getter = desc.get;if (getter === undefined) {
					return undefined;
				}return getter.call(receiver);
			}
		};

		var _metal = require("frontend-js-metal-web$metal");

		var _metalDom = require("frontend-js-metal-web$metal-dom");

		var _metalDom2 = _interopRequireDefault(_metalDom);

		var _Drag2 = require('./Drag');

		var _Drag3 = _interopRequireDefault(_Drag2);

		var _metalPosition = require("frontend-js-metal-web$metal-position");

		var _metalPosition2 = _interopRequireDefault(_metalPosition);

		require("frontend-js-metal-web$metal-events");

		function _interopRequireDefault(obj) {
			return obj && obj.__esModule ? obj : { default: obj };
		}

		function _classCallCheck(instance, Constructor) {
			if (!(instance instanceof Constructor)) {
				throw new TypeError("Cannot call a class as a function");
			}
		}

		function _possibleConstructorReturn(self, call) {
			if (!self) {
				throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
			}return call && (typeof call === "object" || typeof call === "function") ? call : self;
		}

		function _inherits(subClass, superClass) {
			if (typeof superClass !== "function" && superClass !== null) {
				throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
			}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
		}

		/**
   * Adds the functionality of dropping dragged elements to specific
   * targets to the `Drag` class.
   * @extends {Drag}
   */
		var DragDrop = function (_Drag) {
			_inherits(DragDrop, _Drag);

			/**
    * @inheritDoc
    */
			function DragDrop(config) {
				_classCallCheck(this, DragDrop);

				/**
     * The currently active targets, that is, the ones that the dragged source is over.
     * @type {!Array<!Element>}
     * @protected
     */
				var _this = _possibleConstructorReturn(this, (DragDrop.__proto__ || Object.getPrototypeOf(DragDrop)).call(this, config));

				_this.activeTargets_ = [];
				return _this;
			}

			/**
    * Adds a target to this `DragDrop` instance.
    * @param {!Element} target
    */

			_createClass(DragDrop, [{
				key: 'addTarget',
				value: function addTarget(target) {
					this.targets.push(target);
					this.targets = this.targets;
				}

				/**
     * Overrides the original method from `Drag` to include the target on the event object.
     * @return {!Object}
     * @protected
     * @override
     */

			}, {
				key: 'buildEventObject_',
				value: function buildEventObject_() {
					var obj = _get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'buildEventObject_', this).call(this);
					obj.target = this.activeTargets_[0];
					obj.allActiveTargets = this.activeTargets_;
					return obj;
				}

				/**
     * @inheritDoc
     */

			}, {
				key: 'cleanUpAfterDragging_',
				value: function cleanUpAfterDragging_() {
					_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'cleanUpAfterDragging_', this).call(this);
					this.targets.forEach(function (target) {
						return target.removeAttribute('aria-dropeffect');
					});
					if (this.activeTargets_.length) {
						_metalDom2.default.removeClasses(this.activeTargets_[0], this.targetOverClass);
					}
					this.activeTargets_ = [];
				}

				/**
     * Finds all targets that the dragged element is currently over.
     * @return {!Array<!Element>} The current active targets.
     * @protected
     */

			}, {
				key: 'findAllActiveTargets_',
				value: function findAllActiveTargets_() {
					var activeTargets = [];
					var mainRegion = void 0;
					var sourceRegion = this.getSourceRegion_();
					var targets = this.targets;
					targets.forEach(function (target, index) {
						var region = _metalPosition2.default.getRegion(target);
						if (targets[index] !== this.activeDragPlaceholder_ && _metalPosition2.default.intersectRegion(region, sourceRegion)) {
							// eslint-disable-next-line
							if (!mainRegion || _metalPosition2.default.insideRegion(mainRegion, region)) {
								activeTargets = [targets[index]].concat(activeTargets);
								mainRegion = region;
							} else {
								activeTargets.push(targets[index]);
							}
						}
					}.bind(this));
					return activeTargets;
				}

				/**
     * Gets the active source's region, to be used when calculating which targets are active.
     * @return {!Object}
     * @protected
     */

			}, {
				key: 'getSourceRegion_',
				value: function getSourceRegion_() {
					if (_metal.core.isDefAndNotNull(this.mousePos_)) {
						var x = this.mousePos_.x;
						var y = this.mousePos_.y;
						return _metalPosition2.default.makeRegion(y, 0, x, x, y, 0);
					} else {
						// We need to remove the scroll data from the region, since the other regions we'll
						// be comparing to won't take that information into account.
						var region = _metal.object.mixin({}, this.sourceRegion_);
						region.left -= document.body.scrollLeft;
						region.right -= document.body.scrollLeft;
						region.top -= document.body.scrollTop;
						region.bottom -= document.body.scrollTop;
						return region;
					}
				}

				/**
     * Triggers when the `container` state changes. Overrides default method so
     * it will also update `targets` when container changes.
     * @param {!Object} data
     * @param {!Object} event
     * @protected
     */

			}, {
				key: 'handleContainerChanged_',
				value: function handleContainerChanged_(data, event) {
					_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'handleContainerChanged_', this).call(this, data, event);
					if (this.prevTargetsSelector_) {
						this.targets = this.prevTargetsSelector_;
					}
				}

				/**
     * Removes a target from this `DragDrop` instance.
     * @param {!Element} target
     */

			}, {
				key: 'removeTarget',
				value: function removeTarget(target) {
					_metal.array.remove(this.targets, target);
					this.targets = this.targets;
				}

				/**
     * Sets the `targets` state property.
     * @param {Element|string} val
     * @return {!Array<!Element>}
     * @protected
     */

			}, {
				key: 'setterTargetsFn_',
				value: function setterTargetsFn_(val) {
					this.prevTargetsSelector_ = _metal.core.isString(val) ? val : null;
					return this.toElements_(val);
				}

				/**
     * Overrides the original method from `Drag` to also set the "aria-dropeffect"
     * attribute, if set, for all targets.
     */

			}, {
				key: 'startDragging_',
				value: function startDragging_() {
					var _this2 = this;

					if (this.ariaDropEffect) {
						this.targets.forEach(function (target) {
							return target.setAttribute('aria-dropeffect', _this2.ariaDropEffect);
						});
					}
					_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'startDragging_', this).call(this);
				}

				/**
     * Overrides original method from `Drag` to also be enable finding the target
     * the dragged element is over at the new position.
     * @param {number} deltaX
     * @param {number} deltaY
     * @override
     */

			}, {
				key: 'updatePosition',
				value: function updatePosition(deltaX, deltaY) {
					_get(DragDrop.prototype.__proto__ || Object.getPrototypeOf(DragDrop.prototype), 'updatePosition', this).call(this, deltaX, deltaY);

					var newTargets = this.findAllActiveTargets_();
					if (newTargets[0] !== this.activeTargets_[0]) {
						if (this.activeTargets_[0]) {
							_metalDom2.default.removeClasses(this.activeTargets_[0], this.targetOverClass);
							this.emit(DragDrop.Events.TARGET_LEAVE, this.buildEventObject_()); // eslint-disable-line
						}

						this.activeTargets_ = newTargets;
						if (this.activeTargets_[0]) {
							_metalDom2.default.addClasses(this.activeTargets_[0], this.targetOverClass);
							this.emit(DragDrop.Events.TARGET_ENTER, this.buildEventObject_()); // eslint-disable-line
						}
					}
				}
			}]);

			return DragDrop;
		}(_Drag3.default);

		/**
   * State definition.
   * @type {!Object}
   * @static
   */

		DragDrop.STATE = {
			/**
    * The "aria-dropeffect" value to be set for all targets. If not set,
    * this html attribute will have to be set manually on the targets.
    * @type {string}
    */
			ariaDropEffect: {
				validator: _metal.core.isString
			},

			/**
    * The CSS class that should be added to drop targets when a source
    * is being dragged over them.
    * @type {string}
    * @default 'dropOver'
    */
			targetOverClass: {
				validator: _metal.core.isString,
				value: 'targetOver'
			},

			/**
    * Elements that the sources can be dropped on. Can be either a single
    * element or a selector for multiple elements.
    * @type {!Element|string}
    */
			targets: {
				setter: 'setterTargetsFn_',
				validator: 'validateElementOrString_'
			}
		};

		/**
   * Holds the names of events that can be emitted by `DragDrop`.
   * @type {!Object}
   * @static
   */
		DragDrop.Events = {
			DRAG: 'drag',
			END: 'end',
			TARGET_ENTER: 'targetEnter',
			TARGET_LEAVE: 'targetLeave'
		};

		exports.DragDrop = DragDrop;
		exports.Drag = _Drag3.default;
		exports.default = DragDrop;
	}
});
//# sourceMappingURL=DragDrop.js.map