'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-component@2.16.8/lib/ComponentRegistry", ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		Object.defineProperty(exports, "__esModule", {
			value: true
		});

		var _createClass = function () {
			function defineProperties(target, props) {
				for (var i = 0; i < props.length; i++) {
					var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
				}
			}return function (Constructor, protoProps, staticProps) {
				if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
			};
		}();

		var _metal = require("frontend-js-metal-web$metal");

		function _classCallCheck(instance, Constructor) {
			if (!(instance instanceof Constructor)) {
				throw new TypeError("Cannot call a class as a function");
			}
		}

		/**
   * The component registry is used to register components, so they can
   * be accessible by name.
   * @type {Object}
   */
		var ComponentRegistry = function () {
			function ComponentRegistry() {
				_classCallCheck(this, ComponentRegistry);
			}

			_createClass(ComponentRegistry, null, [{
				key: 'getConstructor',

				/**
     * Gets the constructor function for the given component name, or
     * undefined if it hasn't been registered yet.
     * @param {string} name The component's name.
     * @return {?function()}
     * @static
     */
				value: function getConstructor(name) {
					var constructorFn = ComponentRegistry.components_[name];
					if (!constructorFn) {
						console.error('There\'s no constructor registered for the component named ' + name + '.\n\t\t\t\tComponents need to be registered via ComponentRegistry.register.');
					}
					return constructorFn;
				}

				/**
     * Registers a component, so it can be found by its name.
     * @param {!Function} constructorFn The component's constructor function.
     * @param {string=} name Name of the registered component. If none is given
     *   the name defined by the NAME static variable will be used instead. If that
     *   isn't set as well, the name of the constructor function will be used.
     * @static
     */

			}, {
				key: 'register',
				value: function register(constructorFn, name) {
					if (!name) {
						if (constructorFn.hasOwnProperty('NAME')) {
							name = constructorFn.NAME;
						} else {
							name = (0, _metal.getFunctionName)(constructorFn);
						}
					}
					constructorFn.NAME = name;
					ComponentRegistry.components_[name] = constructorFn;
				}
			}]);

			return ComponentRegistry;
		}();

		/**
   * Holds all registered components, indexed by their names.
   * @type {!Object<string, function()>}
   * @protected
   * @static
   */

		ComponentRegistry.components_ = {};

		exports.default = ComponentRegistry;
		//# sourceMappingURL=ComponentRegistry.js.map
	}
});
//# sourceMappingURL=ComponentRegistry.js.map