'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-anim@2.0.1/lib/Anim", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
	var define = undefined;
	var global = window;
	{
		Object.defineProperty(exports, "__esModule", {
			value: true
		});

		var _createClass = function () {
			function defineProperties(target, props) {
				for (var i = 0; i < props.length; i++) {
					var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
				}
			}return function (Constructor, protoProps, staticProps) {
				if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
			};
		}();

		var _metal = require("frontend-js-metal-web$metal");

		var _metal2 = _interopRequireDefault(_metal);

		var _metalDom = require("frontend-js-metal-web$metal-dom");

		function _interopRequireDefault(obj) {
			return obj && obj.__esModule ? obj : { default: obj };
		}

		function _classCallCheck(instance, Constructor) {
			if (!(instance instanceof Constructor)) {
				throw new TypeError("Cannot call a class as a function");
			}
		}

		/**
   * Anim class.
   */
		var Anim = function () {
			function Anim() {
				_classCallCheck(this, Anim);
			}

			_createClass(Anim, null, [{
				key: 'emulateEnd',

				/**
     * Emulates animation or transition end event, the end event with longer
     * duration will be used by the emulation. If they have the same value,
     * transitionend will be emulated.
     * @param {!Element} element
     * @param {number=} optDurationMs
     * @return {!Object} Object containing `abort` function.
     */
				value: function emulateEnd(element, optDurationMs) {
					if (this.getComputedDurationMs(element, 'animation') > this.getComputedDurationMs(element, 'transition')) {
						return this.emulateEnd_(element, 'animation', optDurationMs);
					} else {
						return this.emulateEnd_(element, 'transition', optDurationMs);
					}
				}

				/**
     * Emulates animation end event. If `optDurationMs` not specified the value
     * will read from computed style for animation-duration.
     * @param {!Element} element
     * @param {number=} optDurationMs
     * @return {!Object} Object containing `abort` function.
     */

			}, {
				key: 'emulateAnimationEnd',
				value: function emulateAnimationEnd(element, optDurationMs) {
					return this.emulateEnd_(element, 'animation', optDurationMs);
				}

				/**
     * Emulates transition end event. If `optDurationMs` not specified the
     * value will read from computed style for transition-duration.
     * @param {!Element} element
     * @param {number=} optDurationMs
     * @return {!Object} Object containing `abort` function.
     */

			}, {
				key: 'emulateTransitionEnd',
				value: function emulateTransitionEnd(element, optDurationMs) {
					return this.emulateEnd_(element, 'transition', optDurationMs);
				}

				/**
     * Emulates transition or animation end.
     * @param {!Element} element
     * @param {string} type
     * @param {number=} optDurationMs
     * @return {!Object} Object containing `abort` function.
     * @protected
     */

			}, {
				key: 'emulateEnd_',
				value: function emulateEnd_(element, type, optDurationMs) {
					var duration = optDurationMs;
					if (!_metal2.default.isDef(optDurationMs)) {
						duration = this.getComputedDurationMs(element, type);
					}

					var delayed = setTimeout(function () {
						_metalDom.dom.triggerEvent(element, _metalDom.features.checkAnimationEventName()[type]);
					}, duration);

					var abort = function abort() {
						clearTimeout(delayed);
						hoistedEvtHandler.removeListener();
					};
					var hoistedEvtHandler = _metalDom.dom.once(element, type + 'end', abort);

					return {
						abort: abort
					};
				}

				/**
     * Gets computed style duration for duration.
     * @param {!Element} element
     * @param {string} type
     * @return {number} The computed duration in milliseconds.
     */

			}, {
				key: 'getComputedDurationMs',
				value: function getComputedDurationMs(element, type) {
					return (parseFloat(window.getComputedStyle(element, null).getPropertyValue(type + '-duration')) || 0) * 1000;
				}
			}]);

			return Anim;
		}();

		exports.default = Anim;
	}
});
//# sourceMappingURL=Anim.js.map