'use strict';

/**
 * Debounces function execution.
 * @param {!function()} fn
 * @param {number} [delay=0]
 * @return {!function()}
 */

Liferay.Loader.define("frontend-js-metal-web$metal-throttle@3.0.1/lib/throttle", ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	function throttle(fn) {
		var delay = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

		var last = 0;

		return function () {
			for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
				args[_key] = arguments[_key];
			}

			var next = last + delay;
			var now = Date.now();

			if (next < now) {
				try {
					fn.call.apply(fn, [null].concat(args));
				} catch (error) {
					throw error;
				} finally {
					last = Date.now();
				}
			}
		};
	}

	exports.default = throttle;
	exports.throttle = throttle;
});
//# sourceMappingURL=throttle.js.map