/* eslint-disable */
'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-promise@3.0.5/lib/ProgressPromise", ['module', 'exports', 'require', './CancellablePromise', 'frontend-js-metal-web$metal'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _CancellablePromise2 = require('./CancellablePromise');

	var _CancellablePromise3 = _interopRequireDefault(_CancellablePromise2);

	var _metal = require("frontend-js-metal-web$metal");

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var ProgressPromise = function (_CancellablePromise) {
		_inherits(ProgressPromise, _CancellablePromise);

		/**
   * Creates a CancellablePromise that can track progress.
   * @extends CancellablePromise
   * @constructor
   */
		function ProgressPromise(resolver, opt_context) {
			_classCallCheck(this, ProgressPromise);

			var progressFn = function progressFn(progress) {
				_metal.async.nextTick(function () {
					_this.setProgress_(progress);
				});
			};

			var resolverFn = function resolverFn(resolve, reject) {
				resolver(resolve, reject, progressFn);
			};

			var _this = _possibleConstructorReturn(this, (ProgressPromise.__proto__ || Object.getPrototypeOf(ProgressPromise)).call(this, resolverFn, opt_context));

			_this.listeners_ = [];
			_this.progress_ = 0;
			return _this;
		}

		/**
   * Overwrites `CancellablePromise.prototype.addChildPromise_` so that it
   * implements another `ProgressPromise` as a child.
   * @inheritdoc
   */

		_createClass(ProgressPromise, [{
			key: 'addChildPromise_',
			value: function addChildPromise_(onFulfilled, onRejected, opt_context) {
				var callbackEntry = _CancellablePromise3.default.getCallbackEntry_(null, null, null);

				callbackEntry.child = new ProgressPromise(function (resolve, reject) {
					callbackEntry.onFulfilled = onFulfilled ? function (value) {
						try {
							var result = onFulfilled.call(opt_context, value);

							resolve(result);
						} catch (err) {
							reject(err);
						}
					} : resolve;

					callbackEntry.onRejected = onRejected ? function (reason) {
						try {
							var result = onRejected.call(opt_context, reason);

							if (!(0, _metal.isDef)(result) && reason.IS_CANCELLATION_ERROR) {
								reject(reason);
							} else {
								resolve(result);
							}
						} catch (err) {
							reject(err);
						}
					} : reject;
				});

				callbackEntry.child.parent_ = this;
				this.addCallbackEntry_(callbackEntry);

				return callbackEntry.child;
			}

			/**
    * Invokes any listeners that have been attached to child promises.
    * @param {!number} progress A percentage between 0 and 1
    */

		}, {
			key: 'callChildProgressListeners_',
			value: function callChildProgressListeners_(progress) {
				if (this.callbackEntries_ && this.callbackEntries_.child) {
					this.callProgressListeners_(progress, this.callbackEntries_.child.listeners_);
				}
			}

			/**
    * Invokes any listeners that have been attached via the `progress` method.
    * @param {!number} progress A percentage between 0 and 1
    * @param {!Array} listeners Array of listeners
    */

		}, {
			key: 'callProgressListeners_',
			value: function callProgressListeners_(progress, listeners) {
				if (listeners.length) {
					listeners.forEach(function (listener) {
						listener(progress);
					});
				}
			}

			/**
    * Returns the current progress of the promise instance.
    * Progress will be a number between 0 and 1.
    * @return {number}
    */

		}, {
			key: 'getProgress',
			value: function getProgress() {
				return this.progress_;
			}

			/**
    * Adds a listener that will be called once the progress has been updated.
    * @param {!Function} listener
    */

		}, {
			key: 'progress',
			value: function progress(listener) {
				this.listeners_.push(listener);

				return this;
			}

			/**
    * Updates the current progress of the promise and calls all listeners.
    * @param {number} progress
    */

		}, {
			key: 'setProgress_',
			value: function setProgress_(progress) {
				if (progress > 1 || progress < 0) {
					throw new TypeError('The progress percentage should be a number between 0 and 1');
				} else if (progress < this.progress_) {
					throw new Error("The progress percentage can't be lower than the previous percentage");
				} else if (progress === this.progress_ || progress === 1) {
					return;
				}

				this.progress_ = progress;

				this.callProgressListeners_(progress, this.listeners_);
				this.callChildProgressListeners_(progress);
			}
		}]);

		return ProgressPromise;
	}(_CancellablePromise3.default);

	exports.default = ProgressPromise;
});
//# sourceMappingURL=ProgressPromise.js.map