'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-drag-drop@3.3.1/test/fixtures/DragTestHelper', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	import dom from 'metal-dom';

	/**
  * This class has helper functions for testing the drag components
  */
	class DragTestHelper {
		/**
   * Triggers a `keydown` event on the given target.
   * @param {!Element} target
   * @param {string} keyCode
   * @static
   */
		static triggerKeyEvent(target, keyCode) {
			dom.triggerEvent(target, 'keydown', {
				keyCode: keyCode
			});
		}

		/**
   * Triggers the given mouse event, building the correct data object
   * with the given information, using the shim as target instead of
   * the document, and turning the mouse event into the corresponding
   * touch event if the test is running in a touch device.
   * @param {!Element} target
   * @param {string} eventType
   * @param {number} x
   * @param {number} y
   * @param {number} button
   * @static
   */
		static triggerMouseEvent(target, eventType, x, y, button) {
			let data = {
				button: button ? button : 0,
				clientX: x,
				clientY: y
			};
			if ('ontouchstart' in window) {
				let eventTypesMap = {
					mousedown: 'touchstart',
					mousemove: 'touchmove',
					mouseup: 'touchend'
				};
				eventType = eventTypesMap[eventType];
				data = {
					targetTouches: [data]
				};
			}
			if (target === document) {
				target = document.querySelector('.shim') || document;
			}
			dom.triggerEvent(target, eventType, data);
		}
	}

	export default DragTestHelper;
});
//# sourceMappingURL=DragTestHelper.js.map