'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-debounce@2.0.2/test/debounce', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	import { cancelDebounce, debounce } from '../src/debounce';

	describe('debounce', function () {
		it('should only call received function with the last called args after a delay', function (done) {
			const fn = sinon.stub();

			const debounced = debounce(fn, 200);
			debounced(1, 2, 3);
			debounced(4, 5, 6);

			setTimeout(function () {
				debounced(7, 8, 9);
				debounced(10, 11, 12);
				setTimeout(function () {
					assert.strictEqual(1, fn.callCount);
					assert.deepEqual([10, 11, 12], fn.args[0]);
					done();
				}, 210);
			}, 100);
		});

		it('should call original function with its original context', function (done) {
			const expectedContext = {};
			let context;
			const fn = function () {
				context = this; /* eslint-disable-line */
			};

			const debounced = debounce(fn.bind(expectedContext), 200);
			debounced(1, 2, 3);

			setTimeout(function () {
				assert.strictEqual(expectedContext, context);
				done();
			}, 200);
		});

		it('should only call received function with the last called args after a delay', function (done) {
			const fn = sinon.stub();

			const debounced = debounce(fn, 200);
			debounced(1, 2, 3);
			cancelDebounce(debounced);

			setTimeout(function () {
				assert.strictEqual(0, fn.callCount);
				done();
			}, 210);
		});
	});
});
//# sourceMappingURL=debounce.js.map