'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-component@2.16.8/lib/ComponentDataManager", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var BLACKLIST = {
		components: true,
		context: true,
		element: true,
		refs: true,
		state: true,
		stateKey: true,
		wasRendered: true
	};
	var DATA_MANAGER_DATA = '__DATA_MANAGER_DATA__';

	/**
  * Class to handle Component Data
  */

	var ComponentDataManager = function () {
		function ComponentDataManager() {
			_classCallCheck(this, ComponentDataManager);
		}

		_createClass(ComponentDataManager, [{
			key: 'createState_',

			/**
    * Creates the `State` instance that will handle the main component data.
    * @param {!Component} component
    * @param {!Object} data
    * @protected
    */
			value: function createState_(component, data) {
				var state = new _metalState2.default(component.getInitialConfig(), component, component); // eslint-disable-line
				state.setKeysBlacklist(BLACKLIST);
				state.configState(_metal.object.mixin({}, data, _metalState2.default.getStateStatic(component.constructor)));
				this.getManagerData(component).state_ = state;
			}

			/**
    * Disposes of any data being used by the manager in this component.
    * @param {!Component} component
    */

		}, {
			key: 'dispose',
			value: function dispose(component) {
				var data = this.getManagerData(component);
				if (data.state_) {
					data.state_.dispose();
				}
				component[DATA_MANAGER_DATA] = null;
			}

			/**
    * Gets the data with the given name.
    * @param {!Component} component
    * @param {string} name
    * @return {*}
    */

		}, {
			key: 'get',
			value: function get(component, name) {
				return this.getManagerData(component).state_.get(name);
			}

			/**
    * Gets the manager data for the given component.
    * @param {!Component} component
    * @return {Object}
    */

		}, {
			key: 'getManagerData',
			value: function getManagerData(component) {
				return component[DATA_MANAGER_DATA];
			}

			/**
    * Gets the keys for state data that can be synced via `sync` functions.
    * @param {!Component} component
    * @return {!Array<string>}
    */

		}, {
			key: 'getSyncKeys',
			value: function getSyncKeys(component) {
				return this.getManagerData(component).state_.getStateKeys();
			}

			/**
    * Gets the keys for state data.
    * @param {!Component} component
    * @return {!Array<string>}
    */

		}, {
			key: 'getStateKeys',
			value: function getStateKeys(component) {
				return this.getManagerData(component).state_.getStateKeys();
			}

			/**
    * Gets the whole state data.
    * @param {!Component} component
    * @return {!Object}
    */

		}, {
			key: 'getState',
			value: function getState(component) {
				return this.getManagerData(component).state_.getState();
			}

			/**
    * Gets the `State` instance being used.
    * @param {!Component} component
    * @return {!Object}
    */

		}, {
			key: 'getStateInstance',
			value: function getStateInstance(component) {
				return this.getManagerData(component).state_;
			}

			/**
    * Updates all non internal data with the given values (or to the default
    * value if none is given).
    * @param {!Component} component
    * @param {!Object} data
    * @param {State=} state
    */

		}, {
			key: 'replaceNonInternal',
			value: function replaceNonInternal(component, data) {
				var state = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.getManagerData(component).state_;

				var keys = state.getStateKeys();
				for (var i = 0; i < keys.length; i++) {
					var key = keys[i];
					if (!state.getStateKeyConfig(key).internal) {
						if (data.hasOwnProperty(key) && (0, _metal.isDef)(data[key])) {
							state.set(key, data[key]);
						} else {
							state.setDefaultValue(key);
						}
					}
				}
			}

			/**
    * Sets the value of all the specified state keys.
    * @param {!Component} component
    * @param {!Object.<string,*>} state A map of state keys to the values they
    *   should be set to.
    * @param {function()=} callback An optional function that will be run
    *   after the next batched update is triggered.
    */

		}, {
			key: 'setState',
			value: function setState(component, state, callback) {
				this.getManagerData(component).state_.setState(state, callback);
			}

			/**
    * Sets up the specified component's data.
    * @param {!Component} component
    * @param {!Object} data
    */

		}, {
			key: 'setUp',
			value: function setUp(component, data) {
				component[DATA_MANAGER_DATA] = {};
				this.createState_(component, data);
			}
		}]);

		return ComponentDataManager;
	}();

	exports.default = new ComponentDataManager();
	//# sourceMappingURL=ComponentDataManager.js.map
});
//# sourceMappingURL=ComponentDataManager.js.map