'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-clipboard@2.0.1/lib/Clipboard", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.ClipboardAction = exports.Clipboard = undefined;

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Clipboard component.
  */
	var Clipboard = function (_State) {
		_inherits(Clipboard, _State);

		/**
   * Delegates a click event to the passed selector.
   * @param {*} optConfig
   * @constructor
   */
		function Clipboard(optConfig) {
			_classCallCheck(this, Clipboard);

			var _this = _possibleConstructorReturn(this, (Clipboard.__proto__ || Object.getPrototypeOf(Clipboard)).call(this, optConfig));

			_this.listener_ = _metalDom2.default.on(_this.selector, 'click', function (e) {
				return _this.initialize(e);
			});
			return _this;
		}

		/**
   * @inheritDoc
   */

		_createClass(Clipboard, [{
			key: 'disposeInternal',
			value: function disposeInternal() {
				this.listener_.dispose();
				this.listener_ = null;
				if (this.clipboardAction_) {
					this.clipboardAction_.dispose();
					this.clipboardAction_ = null;
				}
			}

			/**
    * Defines a new `ClipboardAction` on each click event.
    * @param {!Event} e
    */

		}, {
			key: 'initialize',
			value: function initialize(e) {
				if (this.clipboardAction_) {
					this.clipboardAction_ = null;
				}

				this.clipboardAction_ = new ClipboardAction({
					host: this,
					action: this.action(e.delegateTarget),
					target: this.target(e.delegateTarget),
					text: this.text(e.delegateTarget),
					trigger: e.delegateTarget
				});
			}
		}]);

		return Clipboard;
	}(_metalState2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	Clipboard.STATE = {
		/**
   * A function that returns the name of the clipboard action that should be done
   * when for the given element (either 'copy' or 'cut').
   * @type {!function(!Element)}
   */
		action: {
			validator: _metal2.default.isFunction,
			value: function value(delegateTarget) {
				return delegateTarget.getAttribute('data-action');
			}
		},

		/**
   * The selector for all elements that should be listened for clipboard actions.
   * @type {string}
   */
		selector: {
			value: '[data-clipboard]',
			validator: _metal2.default.isString
		},

		/**
   * A function that returns an element that has the content to be copied to the
   * clipboard.
   * @type {!function(!Element)}
   */
		target: {
			validator: _metal2.default.isFunction,
			value: function value(delegateTarget) {
				return document.querySelector(delegateTarget.getAttribute('data-target'));
			}
		},

		/**
   * A function that returns the text to be copied to the clipboard.
   * @type {!function(!Element)}
   */
		text: {
			validator: _metal2.default.isFunction,
			value: function value(delegateTarget) {
				return delegateTarget.getAttribute('data-text');
			}
		}
	};

	/**
  * ClipboardAction component.
  */

	var ClipboardAction = function (_State2) {
		_inherits(ClipboardAction, _State2);

		/**
   * Initializes selection either from a `text` or `target` state.
   * @param {*} optConfig
   * @constructor
   */
		function ClipboardAction(optConfig) {
			_classCallCheck(this, ClipboardAction);

			var _this2 = _possibleConstructorReturn(this, (ClipboardAction.__proto__ || Object.getPrototypeOf(ClipboardAction)).call(this, optConfig));

			if (_this2.text) {
				_this2.selectValue();
			} else if (_this2.target) {
				_this2.selectTarget();
			}
			return _this2;
		}

		/**
   * Removes current selection and focus from `target` element.
   */

		_createClass(ClipboardAction, [{
			key: 'clearSelection',
			value: function clearSelection() {
				if (this.target) {
					this.target.blur();
				}

				window.getSelection().removeAllRanges();
			}

			/**
    * Executes the copy operation based on the current selection.
    */

		}, {
			key: 'copyText',
			value: function copyText() {
				var succeeded = void 0;

				try {
					succeeded = document.execCommand(this.action);
				} catch (err) {
					succeeded = false;
				}

				this.handleResult(succeeded);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'disposeInternal',
			value: function disposeInternal() {
				this.removeFakeElement();
				_get(ClipboardAction.prototype.__proto__ || Object.getPrototypeOf(ClipboardAction.prototype), 'disposeInternal', this).call(this);
			}

			/**
    * Emits an event based on the copy operation result.
    * @param {boolean} succeeded
    */

		}, {
			key: 'handleResult',
			value: function handleResult(succeeded) {
				if (succeeded) {
					this.host.emit('success', {
						action: this.action,
						text: this.selectedText,
						trigger: this.trigger,
						clearSelection: this.clearSelection.bind(this)
					});
				} else {
					this.host.emit('error', {
						action: this.action,
						trigger: this.trigger,
						clearSelection: this.clearSelection.bind(this)
					});
				}
			}

			/**
    * Removes the fake element that was added to the document, as well as its
    * listener.
    */

		}, {
			key: 'removeFakeElement',
			value: function removeFakeElement() {
				if (this.fake) {
					_metalDom2.default.exitDocument(this.fake);
				}

				if (this.removeFakeHandler) {
					this.removeFakeHandler.removeListener();
				}
			}

			/**
    * Selects the content from element passed on `target` state.
    */

		}, {
			key: 'selectTarget',
			value: function selectTarget() {
				if (this.target.nodeName === 'INPUT' || this.target.nodeName === 'TEXTAREA') {
					this.target.select();
					this.selectedText = this.target.value;
				} else {
					var range = document.createRange();
					var selection = window.getSelection();

					range.selectNodeContents(this.target);
					selection.addRange(range);
					this.selectedText = selection.toString();
				}

				this.copyText();
			}

			/**
    * Selects the content from value passed on `text` state.
    */

		}, {
			key: 'selectValue',
			value: function selectValue() {
				this.removeFakeElement();
				this.removeFakeHandler = _metalDom2.default.once(document, 'click', this.removeFakeElement.bind(this));

				this.fake = document.createElement('textarea');
				this.fake.style.position = 'fixed';
				this.fake.style.left = '-9999px';
				this.fake.setAttribute('readonly', '');
				this.fake.value = this.text;
				this.selectedText = this.text;

				_metalDom2.default.enterDocument(this.fake);

				this.fake.select();
				this.copyText();
			}
		}]);

		return ClipboardAction;
	}(_metalState2.default);

	/**
  * State definition.
  * @type {!Object}
  * @static
  */

	ClipboardAction.STATE = {
		/**
   * The action to be performed (either 'copy' or 'cut').
   * @type {string}
   * @default 'copy'
   */
		action: {
			value: 'copy',
			validator: function validator(val) {
				return val === 'copy' || val === 'cut';
			}
		},

		/**
   * A reference to the `Clipboard` base class.
   * @type {!Clipboard}
   */
		host: {
			validator: function validator(val) {
				return val instanceof Clipboard;
			}
		},

		/**
   * The text that is current selected.
   * @type {string}
   */
		selectedText: {
			validator: _metal2.default.isString
		},

		/**
   * The ID of an element that will be have its content copied.
   * @type {Element}
   */
		target: {
			validator: _metal2.default.isElement
		},

		/**
   * The text to be copied.
   * @type {string}
   */
		text: {
			validator: _metal2.default.isString
		},

		/**
   * The element that when clicked initiates a clipboard action.
   * @type {!Element}
   */
		trigger: {
			validator: _metal2.default.isElement
		}
	};

	exports.Clipboard = Clipboard;
	exports.ClipboardAction = ClipboardAction;
	exports.default = Clipboard;
});
//# sourceMappingURL=Clipboard.js.map