'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-toggler@2.3.0/lib/Toggler", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-events', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Toggler = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalEvents = require("frontend-js-metal-web$metal-events");

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Toggler component.
  */
	var Toggler = function (_State) {
		_inherits(Toggler, _State);

		/**
   * @inheritDoc
   */
		function Toggler(config) {
			_classCallCheck(this, Toggler);

			var _this = _possibleConstructorReturn(this, (Toggler.__proto__ || Object.getPrototypeOf(Toggler)).call(this, config));

			_this.headerEventHandler_ = new _metalEvents.EventHandler();

			_this.on('headerChanged', _this.syncHeader);
			_this.syncHeader();
			return _this;
		}

		/**
   * @inheritDoc
   */

		_createClass(Toggler, [{
			key: 'disposeInternal',
			value: function disposeInternal() {
				_get(Toggler.prototype.__proto__ || Object.getPrototypeOf(Toggler.prototype), 'disposeInternal', this).call(this);
				this.headerEventHandler_.removeAllListeners();
			}

			/**
    * Manually collapse the content's visibility.
    * @param {string|!Element} header
    */

		}, {
			key: 'collapse',
			value: function collapse(header) {
				var headerElements = this.getHeaderElements_(header);
				var content = this.getContentElement_(headerElements);

				this.emit('headerToggled', { headerElements: headerElements, content: content });
				this.emit('headerCollapsed', { headerElements: headerElements, content: content });

				_metalDom2.default.removeClasses(content, this.expandedClasses);
				_metalDom2.default.addClasses(content, this.collapsedClasses);
				_metalDom2.default.removeClasses(headerElements, this.headerExpandedClasses);
				_metalDom2.default.addClasses(headerElements, this.headerCollapsedClasses);
				this.setAttribute_(content, 'aria-expanded', false);
				this.setAttribute_(headerElements, 'aria-expanded', false);
			}

			/**
    * Manually expand the content's visibility.
    * @param {string|!Element} header
    */

		}, {
			key: 'expand',
			value: function expand(header) {
				var headerElements = this.getHeaderElements_(header);
				var content = this.getContentElement_(headerElements);

				this.emit('headerToggled', { headerElements: headerElements, content: content });
				this.emit('headerExpanded', { headerElements: headerElements, content: content });

				_metalDom2.default.addClasses(content, this.expandedClasses);
				_metalDom2.default.removeClasses(content, this.collapsedClasses);
				_metalDom2.default.addClasses(headerElements, this.headerExpandedClasses);
				_metalDom2.default.removeClasses(headerElements, this.headerCollapsedClasses);
				this.setAttribute_(content, 'aria-expanded', true);
				this.setAttribute_(headerElements, 'aria-expanded', true);
			}

			/**
    * Gets the content to be toggled by the given header element.
    * @param {!Element} header
    * @return {!Element}
    * @protected
    */

		}, {
			key: 'getContentElement_',
			value: function getContentElement_(header) {
				if (_metal2.default.isElement(this.content)) {
					return this.content;
				}

				var content = _metalDom2.default.next(header, this.content);
				if (content) {
					return content;
				}

				if (_metal2.default.isElement(header)) {
					content = header.querySelector(this.content);
					if (content) {
						return content;
					}
				}

				return this.container.querySelectorAll(this.content);
			}

			/**
    * Gets the header elements by giving a selector.
    * @param {string} header
    * @return {!Nodelist}
    * @protected
    */

		}, {
			key: 'getHeaderElements_',
			value: function getHeaderElements_() {
				var header = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.header;

				if (_metal2.default.isElement(header) || _metal2.default.isElement(header[0])) {
					return header;
				}
				return this.container.querySelectorAll(header);
			}

			/**
    * Handles a `click` event on the header.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleClick_',
			value: function handleClick_(event) {
				this.toggle(event.delegateTarget || event.currentTarget);
			}

			/**
    * Handles a `keydown` event on the header.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'handleKeydown_',
			value: function handleKeydown_(event) {
				if (event.keyCode === 13 || event.keyCode === 32) {
					this.toggle(event.delegateTarget || event.currentTarget);
					event.preventDefault();
				}
			}

			/**
    * Checks if there is any expanded header in the component context.
    * @param {string|!Element} header
    * @return {boolean}
    * @protected
    */

		}, {
			key: 'hasExpanded_',
			value: function hasExpanded_(header) {
				if (_metal2.default.isElement(header)) {
					return _metalDom2.default.hasClass(header, this.headerExpandedClasses);
				}
				return !!this.container.querySelectorAll('.' + this.headerExpandedClasses).length;
			}

			/**
    * Sets attribute on one or more elements.
    * @param {!Element|NodeList} elements
    * @param {!string} name
    * @param {?string|boolean} value
    */

		}, {
			key: 'setAttribute_',
			value: function setAttribute_(elements, name, value) {
				elements = elements instanceof NodeList ? elements : [elements];

				for (var i = 0; i < elements.length; i++) {
					elements[i].setAttribute(name, value);
				}
			}

			/**
    * Syncs the component according to the value of the `header` state,
    * attaching events to the new element and detaching from any previous one.
    */

		}, {
			key: 'syncHeader',
			value: function syncHeader() {
				this.headerEventHandler_.removeAllListeners();
				if (this.header) {
					if (_metal2.default.isString(this.header)) {
						this.headerEventHandler_.add(_metalDom2.default.delegate(this.container, 'click', this.header, this.handleClick_.bind(this)), _metalDom2.default.delegate(this.container, 'keydown', this.header, this.handleKeydown_.bind(this)));
					} else {
						this.headerEventHandler_.add(_metalDom2.default.on(this.header, 'click', this.handleClick_.bind(this)), _metalDom2.default.on(this.header, 'keydown', this.handleKeydown_.bind(this)));
					}
				}
			}

			/**
    * Toggles the content's visibility.
    * @param {string|!Element} header
    */

		}, {
			key: 'toggle',
			value: function toggle(header) {
				var headerElements = this.getHeaderElements_(header);
				if (this.hasExpanded_(headerElements)) {
					this.collapse(headerElements);
				} else {
					this.expand(headerElements);
				}
			}
		}]);

		return Toggler;
	}(_metalState2.default);

	/**
  * State configuration.
  */

	Toggler.STATE = {
		/**
   * The CSS classes added to the content when it's collapsed.
   */
		collapsedClasses: {
			validator: _metal2.default.isString,
			value: 'toggler-collapsed'
		},

		/**
   * The element where the header/content selectors will be looked for.
   * @type {string|!Element}
   */
		container: {
			setter: _metalDom2.default.toElement,
			validator: function validator(value) {
				return _metal2.default.isString(value) || _metal2.default.isElement(value);
			},
			valueFn: function valueFn() {
				return document;
			}
		},

		/**
   * The element that should be expanded/collapsed by this toggler.
   * @type {string|!Element}
   */
		content: {
			validator: function validator(value) {
				return _metal2.default.isString(value) || _metal2.default.isElement(value);
			}
		},

		/**
   * The CSS classes added to the content when it's expanded.
   */
		expandedClasses: {
			validator: _metal2.default.isString,
			value: 'toggler-expanded'
		},

		/**
   * The element that should be trigger toggling.
   * @type {string|!Element}
   */
		header: {
			validator: function validator(value) {
				return _metal2.default.isString(value) || _metal2.default.isElement(value);
			}
		},

		/**
   * The CSS classes added to the header when the content is collapsed.
   */
		headerCollapsedClasses: {
			validator: _metal2.default.isString,
			value: 'toggler-header-collapsed'
		},

		/**
   * The CSS classes added to the header when the content is expanded.
   */
		headerExpandedClasses: {
			validator: _metal2.default.isString,
			value: 'toggler-header-expanded'
		}
	};

	exports.Toggler = Toggler;
	exports.default = Toggler;
});
//# sourceMappingURL=Toggler.js.map