'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-scrollspy@2.1.1/lib/Scrollspy", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});
	exports.Scrollspy = undefined;

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _metalDom = require("frontend-js-metal-web$metal-dom");

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalPosition = require("frontend-js-metal-web$metal-position");

	var _metalPosition2 = _interopRequireDefault(_metalPosition);

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Scrollspy utility.
  */
	var Scrollspy = function (_State) {
		_inherits(Scrollspy, _State);

		/**
   * @inheritDoc
   */
		function Scrollspy(optConfig) {
			_classCallCheck(this, Scrollspy);

			var _this = _possibleConstructorReturn(this, (Scrollspy.__proto__ || Object.getPrototypeOf(Scrollspy)).call(this, optConfig));

			if ((0, _metal.isServerSide)()) {
				return _possibleConstructorReturn(_this);
			}

			/**
    * Holds the regions cache.
    * @type {!Array}
    * @private
    * @default []
    */
			_this.regions = [];

			/**
    * Holds event handle that listens scroll shared event emitter proxy.
    * @type {!EventHandle}
    * @protected
    */
			_this.scrollHandle_ = _metalDom2.default.on(_this.scrollElement, 'scroll', _this.checkPosition.bind(_this));

			_this.init();
			return _this;
		}

		/**
   * @inheritDoc
   */

		_createClass(Scrollspy, [{
			key: 'disposeInternal',
			value: function disposeInternal() {
				if ((0, _metal.isServerSide)()) {
					return;
				}

				this.deactivateAll();
				this.scrollHandle_.dispose();
				_get(Scrollspy.prototype.__proto__ || Object.getPrototypeOf(Scrollspy.prototype), 'disposeInternal', this).call(this);
			}

			/**
    * Activates index matching element.
    * @param {number} index
    */

		}, {
			key: 'activate',
			value: function activate(index) {
				if (this.activeIndex >= 0) {
					this.deactivate(this.activeIndex);
				}
				this.activeIndex = index;
				_metalDom2.default.addClasses(this.getElementForIndex(index), this.activeClass);
			}

			/**
    * Checks position of elements and activate the one in region.
    */

		}, {
			key: 'checkPosition',
			value: function checkPosition() {
				var scrollHeight = this.getScrollHeight_();
				var scrollTop = _metalPosition2.default.getScrollTop(this.scrollElement);

				if (scrollHeight < scrollTop + this.offset) {
					this.activate(this.regions.length - 1);
					return;
				}

				var index = this.findBestRegionAt_();
				if (index !== this.activeIndex) {
					if (index === -1) {
						this.deactivateAll();
					} else {
						this.activate(index);
					}
				}
			}

			/**
    * Deactivates index matching element.
    * @param {number} index
    */

		}, {
			key: 'deactivate',
			value: function deactivate(index) {
				_metalDom2.default.removeClasses(this.getElementForIndex(index), this.activeClass);
			}

			/**
    * Deactivates all elements.
    */

		}, {
			key: 'deactivateAll',
			value: function deactivateAll() {
				for (var i = 0; i < this.regions.length; i++) {
					this.deactivate(i);
				}
				this.activeIndex = -1;
			}

			/**
    * Finds best region to activate.
    * @return {number} The index of best region found.
    */

		}, {
			key: 'findBestRegionAt_',
			value: function findBestRegionAt_() {
				var index = -1;
				var origin = this.getCurrentPosition();
				if (this.regions.length > 0 && origin >= this.regions[0].top) {
					for (var i = 0; i < this.regions.length; i++) {
						var region = this.regions[i];
						var lastRegion = i === this.regions.length - 1;
						if (origin >= region.top && (lastRegion || origin < this.regions[i + 1].top)) {
							index = i;
							break;
						}
					}
				}
				return index;
			}

			/**
    * Gets the current position in the page.
    * @return {number}
    */

		}, {
			key: 'getCurrentPosition',
			value: function getCurrentPosition() {
				var scrollTop = _metalPosition2.default.getScrollTop(this.scrollElement);
				return scrollTop + this.offset + this.scrollElementRegion_.top;
			}

			/**
    * Returns the element that should be used for the link at the given index.
    * @param {number} index
    * @return {!Element}
    */

		}, {
			key: 'getElementForIndex',
			value: function getElementForIndex(index) {
				return this.resolveElement(this.regions[index].link);
			}

			/**
    * Gets the scroll height of `scrollElement`.
    * @return {number}
    * @protected
    */

		}, {
			key: 'getScrollHeight_',
			value: function getScrollHeight_() {
				var scrollHeight = _metalPosition2.default.getHeight(this.scrollElement);
				scrollHeight += this.scrollElementRegion_.top;
				scrollHeight -= _metalPosition2.default.getClientHeight(this.scrollElement);
				return scrollHeight;
			}

			/**
    * Initializes the behavior of scrollspy. It's important to have this as a
    * separate function so subclasses can override it (babel doesn't allow using
    * `this` on constructors before calling `super()`).
    */

		}, {
			key: 'init',
			value: function init() {
				this.refresh();
				this.on('elementChanged', this.refresh);
				this.on('offsetChanged', this.checkPosition);
				this.on('scrollElementChanged', this.onScrollElementChanged_);
				this.on('selectorChanged', this.refresh);
			}

			/**
    * Fired when the value of the `scrollElement` state changes.
    * Refreshes the spy and updates the event handler to listen to the new scroll element.
    * @param {!Event} event
    * @protected
    */

		}, {
			key: 'onScrollElementChanged_',
			value: function onScrollElementChanged_(event) {
				this.refresh();

				this.scrollHandle_.dispose();
				this.scrollHandle_ = _metalDom2.default.on(event.newVal, 'scroll', this.checkPosition.bind(this));
			}

			/**
    * Refreshes all regions from document. Relevant when spying elements that
    * nodes can be added and removed.
    */

		}, {
			key: 'refresh',
			value: function refresh() {
				// Removes the "active" class from all current regions.
				this.deactivateAll();

				this.scrollElementRegion_ = _metalPosition2.default.getRegion(this.scrollElement);
				this.scrollHeight_ = this.getScrollHeight_();

				this.regions = [];
				var links = this.element.querySelectorAll(this.selector);
				var scrollTop = _metalPosition2.default.getScrollTop(this.scrollElement);
				for (var i = 0; i < links.length; ++i) {
					var link = links[i];
					if (link.hash && link.hash.length > 1) {
						var element = document.getElementById(link.hash.substring(1));
						if (element) {
							var region = _metalPosition2.default.getRegion(element);
							this.regions.push({
								link: link,
								top: region.top + scrollTop,
								bottom: region.bottom + scrollTop
							});
						}
					}
				}
				this.sortRegions_();

				// Removes the "active" class from all new regions and then activate the right one for
				// the current position.
				this.deactivateAll();
				this.checkPosition();
			}

			/**
    * Sorts regions from lower to higher on y-axis.
    * @protected
    */

		}, {
			key: 'sortRegions_',
			value: function sortRegions_() {
				this.regions.sort(function (a, b) {
					return a.top - b.top;
				});
			}
		}]);

		return Scrollspy;
	}(_metalState2.default);

	Scrollspy.STATE = {
		/**
   * Class to be used as active class.
   * @type {string}
   */
		activeClass: {
			validator: _metal.core.isString,
			value: 'active'
		},

		/**
   * The index of the currently active link.
   * @type {number}
   */
		activeIndex: {
			validator: _metal.core.isNumber,
			value: -1
		},

		/**
   * Function that receives the matching element as argument and return
   * itself. Relevant when the `activeClass` must be applied to a different
   * element, e.g. a parentNode.
   * @type {function}
   * @default core.identityFunction
   */
		resolveElement: {
			validator: _metal.core.isFunction,
			value: _metal.core.identityFunction
		},

		/**
   * The scrollElement element to be used as scrollElement area for scrollspy.
   * The scrollElement is where the scroll event is listened from.
   * @type {Element|Window}
   */
		scrollElement: {
			setter: _metalDom2.default.toElement,
			valueFn: function valueFn() {
				if (!(0, _metal.isServerSide)()) {
					return document;
				}
			}
		},

		/**
   * Defines the offset that triggers scrollspy.
   * @type {number}
   * @default 0
   */
		offset: {
			validator: _metal.core.isNumber,
			value: 0
		},

		/**
   * Element to be used as alignment reference of scrollspy.
   * @type {Element}
   */
		element: {
			setter: _metalDom2.default.toElement
		},

		/**
   * Selector to query elements inside `element` to be activated.
   * @type {Element}
   * @default 'a'
   */
		selector: {
			validator: _metal.core.isString,
			value: 'a'
		}
	};

	exports.Scrollspy = Scrollspy;
	exports.default = Scrollspy;
});
//# sourceMappingURL=Scrollspy.js.map