Liferay.Loader.define('frontend-js-metal-web$metal-router@3.6.3/build/amd/metal-dom/src/events', ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	define(['./dom', './features'], function (_dom, _features) {
		'use strict';

		var _features2 = function _interopRequireDefault(obj) {
			return obj && obj.__esModule ? obj : {
				default: obj
			};
		}(_features);

		var mouseEventMap = {
			mouseenter: 'mouseover',
			mouseleave: 'mouseout',
			pointerenter: 'pointerover',
			pointerleave: 'pointerout'
		};
		Object.keys(mouseEventMap).forEach(function (eventName) {
			(0, _dom.registerCustomEvent)(eventName, {
				delegate: true,
				handler: function handler(callback, event) {
					var related = event.relatedTarget;
					var target = event.delegateTarget;
					if (!related || related !== target && !(0, _dom.contains)(target, related)) {
						event.customType = eventName;
						return callback(event);
					}
				},
				originalEvent: mouseEventMap[eventName]
			});
		});

		var animationEventMap = {
			animation: 'animationend',
			transition: 'transitionend'
		};
		Object.keys(animationEventMap).forEach(function (eventType) {
			var eventName = animationEventMap[eventType];
			(0, _dom.registerCustomEvent)(eventName, {
				event: true,
				delegate: true,
				handler: function handler(callback, event) {
					event.customType = eventName;
					return callback(event);
				},
				originalEvent: _features2.default.checkAnimationEventName()[eventType]
			});
		});
	});
	//# sourceMappingURL=events.js.map
});
//# sourceMappingURL=events.js.map