// Copyright 2015 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

'use strict';

/**
 * @fileoverview Simple freelist.
 *
 * An anterative to goog.structs.SimplePool, it imposes the requirement that the
 * objects in the list contain a "next" property that can be used to maintain
 * the pool.
 */

/**
 * @template ITEM
 */

Liferay.Loader.define("frontend-js-metal-web$metal-promise@3.0.5/lib/FreeList", ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var FreeList = function () {
		/**
   * @param {function():ITEM} create
   * @param {function(ITEM):void} reset
   * @param {number} limit
   */
		function FreeList(create, reset, limit) {
			_classCallCheck(this, FreeList);

			/** @private @const {number} */
			this.limit_ = limit;
			/** @private @const {function()} */
			this.create_ = create;
			/** @private @const {function(ITEM):void} */
			this.reset_ = reset;

			/** @private {number} */
			this.occupants_ = 0;
			/** @private {ITEM} */
			this.head_ = null;
		}

		/**
   * @return {ITEM}
   */

		_createClass(FreeList, [{
			key: 'get',
			value: function get() {
				var item = void 0;
				if (this.occupants_ > 0) {
					this.occupants_--;
					item = this.head_;
					this.head_ = item.next;
					item.next = null;
				} else {
					item = this.create_();
				}
				return item;
			}

			/**
    * @param {ITEM} item An item available for possible future reuse.
    */

		}, {
			key: 'put',
			value: function put(item) {
				this.reset_(item);
				if (this.occupants_ < this.limit_) {
					this.occupants_++;
					item.next = this.head_;
					this.head_ = item;
				}
			}

			/**
    * Visible for testing.
    * @package
    * @return {number}
    */

		}, {
			key: 'occupants',
			value: function occupants() {
				return this.occupants_;
			}
		}]);

		return FreeList;
	}();

	exports.default = FreeList;
});
//# sourceMappingURL=FreeList.js.map