'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-keyboard-focus@2.0.1/lib/KeyboardFocusManager', ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-events'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _metal = require('frontend-js-metal-web$metal');

	var _metal2 = _interopRequireDefault(_metal);

	var _metalEvents = require('frontend-js-metal-web$metal-events');

	var _metalEvents2 = _interopRequireDefault(_metalEvents);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Listens to keyboard events and uses them to move focus between different
  * elements from a component (via the arrow keys for example).
  * By default `KeyboardFocusManager` will assume that all focusable elements
  * in the component will have refs that follow the pattern in
  * KeyboardFocusManager.REF_REGEX, which includes a position number. The arrow
  * keys will then automatically move between elements by
  * incrementing/decrementing this position.
  * It's possible to fully customize this behavior by passing a function to
  * `setFocusHandler`. For more details check this function's docs.
  */
	var KeyboardFocusManager = function (_EventEmitter) {
		_inherits(KeyboardFocusManager, _EventEmitter);

		/**
   * Constructor for `KeyboardFocusManager`.
   * @param {!Component} component
   * @param {string=} opt_selector
   */
		function KeyboardFocusManager(component, opt_selector) {
			_classCallCheck(this, KeyboardFocusManager);

			var _this = _possibleConstructorReturn(this, _EventEmitter.call(this));

			_this.component_ = component;
			_this.selector_ = opt_selector || '*';
			_this.handleKey_ = _this.handleKey_.bind(_this);
			return _this;
		}

		/**
   * Builds a ref string for the given position.
   * @param {string} prefix
   * @param {number|string} position
   * @return {string}
   * @protected
   */

		KeyboardFocusManager.prototype.buildRef_ = function buildRef_(prefix, position) {
			return prefix + position;
		};

		/**
   * @inheritDoc
   */

		KeyboardFocusManager.prototype.disposeInternal = function disposeInternal() {
			_EventEmitter.prototype.disposeInternal.call(this);
			this.stop();
			this.component_ = null;
			this.selector_ = null;
		};

		/**
   * Gets the next focusable element, that is, the next element that doesn't
   * have the `data-unfocusable` attribute set to `true`.
   * @param {string} prefix
   * @param {number} position
   * @param {number} increment
   * @return {string}
   * @protected
   */

		KeyboardFocusManager.prototype.getNextFocusable_ = function getNextFocusable_(prefix, position, increment) {
			var initialPosition = position;
			var element = void 0;
			var ref = void 0;
			do {
				position = this.increment_(position, increment);
				ref = this.buildRef_(prefix, position);
				element = this.component_.refs[ref];
			} while (this.isFocusable_(element) && position !== initialPosition);
			return element ? ref : null;
		};

		/**
   * Handles a `keydown` event. Decides if a new element should be focused
   * according to the key that was pressed.
   * @param {!Event} event
   * @protected
   */

		KeyboardFocusManager.prototype.handleKey_ = function handleKey_(event) {
			var element = this.focusHandler_ && this.focusHandler_(event);
			if (!this.focusHandler_ || element === true) {
				element = this.handleKeyDefault_(event);
			}

			var originalValue = element;
			if (!_metal2.default.isElement(element)) {
				element = this.component_.refs[element];
			}
			if (element) {
				element.focus();
				this.emit(KeyboardFocusManager.EVENT_FOCUSED, {
					element: element,
					ref: _metal2.default.isString(originalValue) ? originalValue : null
				});
			}
		};

		/**
   * Handles a key press according to the default behavior. Assumes that all
   * focusable elements in the component will have refs that follow the pattern
   * in KeyboardFocusManager.REF_REGEX, which includes a position number. The
   * arrow keys will then automatically move between elements by
   * incrementing/decrementing the position.
   * @param {!Event} event
   * @protected
   */

		KeyboardFocusManager.prototype.handleKeyDefault_ = function handleKeyDefault_(event) {
			var ref = event.delegateTarget.getAttribute('ref');
			var matches = KeyboardFocusManager.REF_REGEX.exec(ref);
			if (!matches) {
				return;
			}

			var position = parseInt(matches[1], 10);
			var prefix = ref.substr(0, ref.length - matches[1].length);
			switch (event.keyCode) {
				case 37:
				case 38:
					// Left/up arrow keys will focus the previous element.
					return this.getNextFocusable_(prefix, position, -1);
				case 39:
				case 40:
					// Right/down arrow keys will focus the next element.
					return this.getNextFocusable_(prefix, position, 1);
			}
		};

		/**
   * Increments the given position, making sure to follow circular rules if
   * enabled.
   * @param {number} position
   * @param {number} increment
   * @return {number}
   * @protected
   */

		KeyboardFocusManager.prototype.increment_ = function increment_(position, increment) {
			var size = this.circularLength_;
			position += increment;
			if (_metal2.default.isNumber(size)) {
				if (position < 0) {
					position = size - 1;
				} else if (position >= size) {
					position = 0;
				}
			}
			return position;
		};

		/**
   * Checks if the given element is focusable.
   * @param {Element} element
   * @return {boolean}
   * @protected
   */

		KeyboardFocusManager.prototype.isFocusable_ = function isFocusable_(element) {
			return element && element.getAttribute('data-unfocusable') === 'true';
		};

		/**
   * Sets the length of the focusable elements. If a number is passed, the
   * default focusing behavior will follow a circular pattern, going from the
   * last to the first element, and vice versa.
   * @param {?number} circularLength
   * @chainable
   */

		KeyboardFocusManager.prototype.setCircularLength = function setCircularLength(circularLength) {
			this.circularLength_ = circularLength;
			return this;
		};

		/**
   * Sets a handler function that will be called to decide which element should
   * be focused according to the key that was pressed. It will receive the key
   * event and should return one of the following:
   *   - `true`, if the default behavior should be triggered instead.
   *   - A string, representing a `ref` to the component element that should be
   *       focused.
   *   - The element itself that should be focused.
   *   - Anything else, if nothing should be focused (skipping default behavior
   *       too).
   * @param {function(key: string)} focusHandler
   * @chainable
   */

		KeyboardFocusManager.prototype.setFocusHandler = function setFocusHandler(focusHandler) {
			this.focusHandler_ = focusHandler;
			return this;
		};

		/**
   * Starts listening to keyboard events and handling element focus.
   * @chainable
   */

		KeyboardFocusManager.prototype.start = function start() {
			if (!this.handle_) {
				this.handle_ = this.component_.delegate('keydown', this.selector_, this.handleKey_);
			}
			return this;
		};

		/**
   * Stops listening to keyboard events and handling element focus.
   * @chainable
   */

		KeyboardFocusManager.prototype.stop = function stop() {
			if (this.handle_) {
				this.handle_.removeListener();
				this.handle_ = null;
			}
			return this;
		};

		return KeyboardFocusManager;
	}(_metalEvents2.default);

	// Event emitted when a selected element was focused via the keyboard.


	KeyboardFocusManager.EVENT_FOCUSED = 'focused';

	// The regex used to extract the position from an element's ref.
	KeyboardFocusManager.REF_REGEX = /.+-(\d+)$/;

	exports.default = KeyboardFocusManager;
});
//# sourceMappingURL=KeyboardFocusManager.js.map