'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-jsx@2.16.8/lib/JSXRenderer", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-incremental-dom'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _metalIncrementalDom = require("frontend-js-metal-web$metal-incremental-dom");

	var _metalIncrementalDom2 = _interopRequireDefault(_metalIncrementalDom);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	var COUNT_PROP = '__metalJsxCount';
	var INC_DOM_DATA = '__incrementalDOMData';
	var KEY_PREFIX = '_metal_jsx_';

	/**
  * Renderer that handles JSX.
  */

	var JSXRenderer = function (_IncrementalDomRender) {
		_inherits(JSXRenderer, _IncrementalDomRender);

		function JSXRenderer() {
			_classCallCheck(this, JSXRenderer);

			return _possibleConstructorReturn(this, (JSXRenderer.__proto__ || Object.getPrototypeOf(JSXRenderer)).apply(this, arguments));
		}

		_createClass(JSXRenderer, [{
			key: 'buildShouldUpdateArgs',

			/**
    * @inheritDoc
    */
			value: function buildShouldUpdateArgs(changes) {
				return [changes.state, changes.props];
			}

			/**
    * Called when generating a key for the next dom element to be created via
    * incremental dom. Adds keys to elements that don't have one yet, according
    * to their position in the parent. This helps use cases that use
    * conditionally rendered elements, which is very common in JSX.
    * @param {!Component} component
    * @param {string} key
    * @return {?string}
    */

		}, {
			key: 'generateKey',
			value: function generateKey(component, key) {
				key = _get(JSXRenderer.prototype.__proto__ || Object.getPrototypeOf(JSXRenderer.prototype), 'generateKey', this).call(this, component, key);
				var comp = this.getPatchingComponent();
				var data = comp.getRenderer().getData(comp);
				if (!(0, _metal.isDefAndNotNull)(key)) {
					if (data.rootElementRendered) {
						key = KEY_PREFIX + jsxRenderer_.incElementCount();
					} else if (comp.element && comp.element[INC_DOM_DATA]) {
						key = comp.element[INC_DOM_DATA].key;
					}
				}
				if (!data.rootElementRendered) {
					data.rootElementRendered = true;
				}
				return key;
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'handleNodeRendered',
			value: function handleNodeRendered(node) {
				node[COUNT_PROP] = 0;
			}

			/**
    * Increments the number of children in the current element.
    * @return {number}
    */

		}, {
			key: 'incElementCount',
			value: function incElementCount() {
				var node = IncrementalDOM.currentElement();
				node[COUNT_PROP] = (node[COUNT_PROP] || 0) + 1;
				return node[COUNT_PROP];
			}

			/**
    * Overrides the original method from `IncrementalDomRenderer` so we can
    * keep track of if the root element of the patched component has already
    * been rendered or not.
    * @param {!Component} component
    * @override
    */

		}, {
			key: 'patch',
			value: function patch(component) {
				this.getData(component).rootElementRendered = false;
				_get(JSXRenderer.prototype.__proto__ || Object.getPrototypeOf(JSXRenderer.prototype), 'patch', this).call(this, component);
			}

			/**
    * Overrides the original method from `IncrementalDomRenderer` to handle the
    * case where developers return a child node directly from the "render"
    * function.
    * @param {!Component} component
    * @override
    */

		}, {
			key: 'renderIncDom',
			value: function renderIncDom(component) {
				if (component.render) {
					iDOMHelpers.renderArbitrary(component.render());
				} else {
					_get(JSXRenderer.prototype.__proto__ || Object.getPrototypeOf(JSXRenderer.prototype), 'renderIncDom', this).call(this, component);
				}
			}

			/**
    * Skips the current child in the count (used when a conditional render
    * decided not to render anything).
    */

		}, {
			key: 'skipChild',
			value: function skipChild() {
				IncrementalDOM.elementVoid(jsxRenderer_.incElementCount);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'skipRender',
			value: function skipRender() {
				jsxRenderer_.skipChild();
				_get(JSXRenderer.prototype.__proto__ || Object.getPrototypeOf(JSXRenderer.prototype), 'skipRender', this).call(this);
			}
		}]);

		return JSXRenderer;
	}(_metalIncrementalDom2.default.constructor);

	var jsxRenderer_ = new JSXRenderer();
	jsxRenderer_.RENDERER_NAME = 'jsx';

	exports.default = jsxRenderer_;
	//# sourceMappingURL=JSXRenderer.js.map
});
//# sourceMappingURL=JSXRenderer.js.map