'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-incremental-dom@2.16.8/src/data', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  const RENDERER_DATA = '__METAL_IC_RENDERER_DATA__';

  /**
   * Removes the incremental dom renderer data object for this component.
   * @param {!Component} component
   */
  export function clearData(component) {
    component[RENDERER_DATA] = null;
  }

  /**
   * Gets the incremental dom renderer data object for this component, creating
   * it if it doesn't exist yet.
   * @param {!Component} component
   * @return {!Object}
   */
  export function getData(component) {
    if (!component[RENDERER_DATA]) {
      component[RENDERER_DATA] = {};
    }
    return component[RENDERER_DATA];
  }
});
//# sourceMappingURL=data.js.map