'use strict';

/**
 * Debounces function execution.
 * @param {!function()} fn
 * @param {number} delay
 * @return {!function()}
 */

Liferay.Loader.define('frontend-js-metal-web$metal-debounce@2.0.2/src/debounce', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  function debounce(fn, delay) {
    return function debounced() {
      const args = Array.prototype.slice.call(arguments, 0);
      cancelDebounce(debounced);
      debounced.id = setTimeout(function () {
        fn.apply(null, args);
      }, delay);
    };
  }

  /**
   * Cancels the scheduled debounced function.
   * @param {function()} debounced
   */
  function cancelDebounce(debounced) {
    clearTimeout(debounced.id);
  }

  export default debounce;
  export { cancelDebounce, debounce };
});
//# sourceMappingURL=debounce.js.map