'use strict';

/* jshint ignore:start */

/**
 * Abstract interface for storing and retrieving data using some persistence
 * mechanism.
 * @constructor
 */

Liferay.Loader.define("frontend-js-metal-web$metal-storage@1.1.0/lib/mechanism/StorageMechanism", ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var StorageMechanism = function () {
		function StorageMechanism() {
			_classCallCheck(this, StorageMechanism);
		}

		_createClass(StorageMechanism, [{
			key: 'clear',

			/**
    * Clear all items from the data storage.
    */
			value: function clear() {
				throw Error('Unimplemented abstract method');
			}

			/**
    * Sets an item in the data storage.
    * @param {string} key The key to set.
    * @param {*} value The value to serialize to a string and save.
    */

		}, {
			key: 'set',
			value: function set(key, value) {
				throw Error('Unimplemented abstract method');
			}

			/**
    * Gets an item from the data storage.
    * @param {string} key The key to get.
    * @return {*} Deserialized value or undefined if not found.
    */

		}, {
			key: 'get',
			value: function get(key) {
				throw Error('Unimplemented abstract method');
			}

			/**
    * Checks if this mechanism is supported in the current environment.
    * Subclasses should override this when necessary.
    */

		}, {
			key: 'keys',

			/**
    * Returns the list of keys stored in the Storage object.
    * @param {!Array<string>} keys
    */
			value: function keys() {
				throw Error('Unimplemented abstract method');
			}

			/**
    * Removes an item from the data storage.
    * @param {string} key The key to remove.
    */

		}, {
			key: 'remove',
			value: function remove(key) {
				throw Error('Unimplemented abstract method');
			}

			/**
    * Returns the number of data items stored in the Storage object.
    * @return {number}
    */

		}, {
			key: 'size',
			value: function size() {
				throw Error('Unimplemented abstract method');
			}
		}], [{
			key: 'isSupported',
			value: function isSupported() {
				return true;
			}
		}]);

		return StorageMechanism;
	}();

	exports.default = StorageMechanism;

	/* jshint ignore:end */
});
//# sourceMappingURL=StorageMechanism.js.map