'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-storage@1.1.0/lib/mechanism/LocalStorageMechanism", ['module', 'exports', 'require', './StorageMechanism'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _StorageMechanism2 = require('./StorageMechanism');

	var _StorageMechanism3 = _interopRequireDefault(_StorageMechanism2);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Abstract interface for storing and retrieving data using some persistence
  * mechanism.
  * @constructor
  */
	var LocalStorageMechanism = function (_StorageMechanism) {
		_inherits(LocalStorageMechanism, _StorageMechanism);

		function LocalStorageMechanism() {
			_classCallCheck(this, LocalStorageMechanism);

			return _possibleConstructorReturn(this, (LocalStorageMechanism.__proto__ || Object.getPrototypeOf(LocalStorageMechanism)).apply(this, arguments));
		}

		_createClass(LocalStorageMechanism, [{
			key: 'storage',

			/**
    * Returns reference for global local storage. by default
    */
			value: function storage() {
				return LocalStorageMechanism.globals.localStorage;
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'clear',
			value: function clear() {
				this.storage().clear();
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'keys',
			value: function keys() {
				return Object.keys(this.storage());
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'get',
			value: function get(key) {
				return this.storage().getItem(key);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'remove',

			/**
    * @inheritDoc
    */
			value: function remove(key) {
				this.storage().removeItem(key);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'set',
			value: function set(key, value) {
				this.storage().setItem(key, value);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'size',
			value: function size() {
				return this.storage().length;
			}
		}], [{
			key: 'isSupported',
			value: function isSupported() {
				return typeof window !== 'undefined' && typeof window.localStorage !== 'undefined';
			}
		}]);

		return LocalStorageMechanism;
	}(_StorageMechanism3.default);

	if (LocalStorageMechanism.isSupported()) {
		LocalStorageMechanism.globals = {
			localStorage: window.localStorage
		};
	}

	exports.default = LocalStorageMechanism;
});
//# sourceMappingURL=LocalStorageMechanism.js.map