'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-storage@1.1.0/lib/Storage", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', './mechanism/StorageMechanism'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metal2 = _interopRequireDefault(_metal);

	var _StorageMechanism = require('./mechanism/StorageMechanism');

	var _StorageMechanism2 = _interopRequireDefault(_StorageMechanism);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var Storage = function () {

		/**
   * Provides a convenient API for data persistence using a selected data
   * storage mechanism.
   * @param {!StorageMechanism} mechanism The underlying storage mechanism.
   * @constructor
   */
		function Storage(mechanism) {
			_classCallCheck(this, Storage);

			assertMechanismDefAndNotNull(mechanism);
			assertMechanismInstanceOf(mechanism);

			/**
    * The mechanism used to persist key-value pairs.
    * @type {StorageMechanism}
    * @protected
    */
			this.mechanism = mechanism;
		}

		/**
   * Clear all items from the data storage.
   */

		_createClass(Storage, [{
			key: 'clear',
			value: function clear() {
				this.mechanism.clear();
			}

			/**
    * Sets an item in the data storage.
    * @param {string} key The key to set.
    * @param {*} value The value to serialize to a string and save.
    */

		}, {
			key: 'set',
			value: function set(key, value) {
				if (!_metal2.default.isDef(value)) {
					this.mechanism.remove(key);
					return;
				}
				this.mechanism.set(key, JSON.stringify(value));
			}

			/**
    * Gets an item from the data storage.
    * @param {string} key The key to get.
    * @return {*} Deserialized value or undefined if not found.
    */

		}, {
			key: 'get',
			value: function get(key) {
				var json;
				try {
					json = this.mechanism.get(key);
				} catch (e) {
					return undefined;
				}
				if (_metal2.default.isNull(json)) {
					return undefined;
				}
				try {
					return JSON.parse(json);
				} catch (e) {
					throw Storage.ErrorCode.INVALID_VALUE;
				}
			}

			/**
    * Returns the list of keys stored in the Storage object.
    * @param {!Array<string>} keys
    */

		}, {
			key: 'keys',
			value: function keys() {
				return this.mechanism.keys();
			}

			/**
    * Removes an item from the data storage.
    * @param {string} key The key to remove.
    */

		}, {
			key: 'remove',
			value: function remove(key) {
				this.mechanism.remove(key);
			}

			/**
    * Returns the number of data items stored in the Storage object.
    * @return {number}
    */

		}, {
			key: 'size',
			value: function size() {
				return this.mechanism.size();
			}

			/**
    * Returns the list of values stored in the Storage object.
    * @param {!Array<string>} values
    */

		}, {
			key: 'values',
			value: function values() {
				var _this = this;

				return this.keys().map(function (key) {
					return _this.get(key);
				});
			}
		}]);

		return Storage;
	}();

	/**
  * Errors thrown by the storage.
  * @enum {string}
  */

	Storage.ErrorCode = {
		INVALID_VALUE: 'Storage: Invalid value was encountered'
	};

	function assertMechanismDefAndNotNull(mechanism) {
		if (!_metal2.default.isDefAndNotNull(mechanism)) {
			throw Error('Storage mechanism is required');
		}
	}

	function assertMechanismInstanceOf(mechanism) {
		if (!(mechanism instanceof _StorageMechanism2.default)) {
			throw Error('Storage mechanism must me an implementation of StorageMechanism');
		}
	}

	exports.default = Storage;
});
//# sourceMappingURL=Storage.js.map