'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-scrollspy@2.0.0/lib/Scrollspy', ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom', 'frontend-js-metal-web$metal-position', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _metal = require('frontend-js-metal-web$metal');

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require('frontend-js-metal-web$metal-dom');

	var _metalDom2 = _interopRequireDefault(_metalDom);

	var _metalPosition = require('frontend-js-metal-web$metal-position');

	var _metalPosition2 = _interopRequireDefault(_metalPosition);

	var _metalState = require('frontend-js-metal-web$metal-state');

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Scrollspy utility.
  */
	var Scrollspy = function (_State) {
		_inherits(Scrollspy, _State);

		/**
   * @inheritDoc
   */
		function Scrollspy(opt_config) {
			_classCallCheck(this, Scrollspy);

			/**
    * Holds the regions cache.
    * @type {!Array}
    * @private
    * @default []
    */
			var _this = _possibleConstructorReturn(this, _State.call(this, opt_config));

			_this.regions = [];

			/**
    * Holds event handle that listens scroll shared event emitter proxy.
    * @type {!EventHandle}
    * @protected
    */
			_this.scrollHandle_ = _metalDom2.default.on(_this.scrollElement, 'scroll', _this.checkPosition.bind(_this));

			_this.init();
			return _this;
		}

		/**
   * @inheritDoc
   */

		Scrollspy.prototype.disposeInternal = function disposeInternal() {
			this.deactivateAll();
			this.scrollHandle_.dispose();
			_State.prototype.disposeInternal.call(this);
		};

		/**
   * Activates index matching element.
   * @param {number} index
   */

		Scrollspy.prototype.activate = function activate(index) {
			if (this.activeIndex >= 0) {
				this.deactivate(this.activeIndex);
			}
			this.activeIndex = index;
			_metalDom2.default.addClasses(this.getElementForIndex(index), this.activeClass);
		};

		/**
   * Checks position of elements and activate the one in region.
   */

		Scrollspy.prototype.checkPosition = function checkPosition() {
			var scrollHeight = this.getScrollHeight_();
			var scrollTop = _metalPosition2.default.getScrollTop(this.scrollElement);

			if (scrollHeight < scrollTop + this.offset) {
				this.activate(this.regions.length - 1);
				return;
			}

			var index = this.findBestRegionAt_();
			if (index !== this.activeIndex) {
				if (index === -1) {
					this.deactivateAll();
				} else {
					this.activate(index);
				}
			}
		};

		/**
   * Deactivates index matching element.
   * @param {number} index
   */

		Scrollspy.prototype.deactivate = function deactivate(index) {
			_metalDom2.default.removeClasses(this.getElementForIndex(index), this.activeClass);
		};

		/**
   * Deactivates all elements.
   */

		Scrollspy.prototype.deactivateAll = function deactivateAll() {
			for (var i = 0; i < this.regions.length; i++) {
				this.deactivate(i);
			}
			this.activeIndex = -1;
		};

		/**
   * Finds best region to activate.
   * @return {number} The index of best region found.
   */

		Scrollspy.prototype.findBestRegionAt_ = function findBestRegionAt_() {
			var index = -1;
			var origin = this.getCurrentPosition();
			if (this.regions.length > 0 && origin >= this.regions[0].top) {
				for (var i = 0; i < this.regions.length; i++) {
					var region = this.regions[i];
					var lastRegion = i === this.regions.length - 1;
					if (origin >= region.top && (lastRegion || origin < this.regions[i + 1].top)) {
						index = i;
						break;
					}
				}
			}
			return index;
		};

		/**
   * Gets the current position in the page.
   * @return {number}
   */

		Scrollspy.prototype.getCurrentPosition = function getCurrentPosition() {
			var scrollTop = _metalPosition2.default.getScrollTop(this.scrollElement);
			return scrollTop + this.offset + this.scrollElementRegion_.top;
		};

		/**
   * Returns the element that should be used for the link at the given index.
   * @param {number} index
   * @return {!Element}
   */

		Scrollspy.prototype.getElementForIndex = function getElementForIndex(index) {
			return this.resolveElement(this.regions[index].link);
		};

		/**
   * Gets the scroll height of `scrollElement`.
   * @return {number}
   * @protected
   */

		Scrollspy.prototype.getScrollHeight_ = function getScrollHeight_() {
			var scrollHeight = _metalPosition2.default.getHeight(this.scrollElement);
			scrollHeight += this.scrollElementRegion_.top;
			scrollHeight -= _metalPosition2.default.getClientHeight(this.scrollElement);
			return scrollHeight;
		};

		/**
   * Initializes the behavior of scrollspy. It's important to have this as a
   * separate function so subclasses can override it (babel doesn't allow using
   * `this` on constructors before calling `super()`).
   */

		Scrollspy.prototype.init = function init() {
			this.refresh();
			this.on('elementChanged', this.refresh);
			this.on('offsetChanged', this.checkPosition);
			this.on('scrollElementChanged', this.onScrollElementChanged_);
			this.on('selectorChanged', this.refresh);
		};

		/**
   * Fired when the value of the `scrollElement` state changes.
   * Refreshes the spy and updates the event handler to listen to the new scroll element.
   * @param {!Event} event
   * @protected
   */

		Scrollspy.prototype.onScrollElementChanged_ = function onScrollElementChanged_(event) {
			this.refresh();

			this.scrollHandle_.dispose();
			this.scrollHandle_ = _metalDom2.default.on(event.newVal, 'scroll', this.checkPosition.bind(this));
		};

		/**
   * Refreshes all regions from document. Relevant when spying elements that
   * nodes can be added and removed.
   */

		Scrollspy.prototype.refresh = function refresh() {
			// Removes the "active" class from all current regions.
			this.deactivateAll();

			this.scrollElementRegion_ = _metalPosition2.default.getRegion(this.scrollElement);
			this.scrollHeight_ = this.getScrollHeight_();

			this.regions = [];
			var links = this.element.querySelectorAll(this.selector);
			var scrollTop = _metalPosition2.default.getScrollTop(this.scrollElement);
			for (var i = 0; i < links.length; ++i) {
				var link = links[i];
				if (link.hash && link.hash.length > 1) {
					var element = document.getElementById(link.hash.substring(1));
					if (element) {
						var region = _metalPosition2.default.getRegion(element);
						this.regions.push({
							link: link,
							top: region.top + scrollTop,
							bottom: region.bottom + scrollTop
						});
					}
				}
			}
			this.sortRegions_();

			// Removes the "active" class from all new regions and then activate the right one for
			// the current position.
			this.deactivateAll();
			this.checkPosition();
		};

		/**
   * Sorts regions from lower to higher on y-axis.
   * @protected
   */

		Scrollspy.prototype.sortRegions_ = function sortRegions_() {
			this.regions.sort(function (a, b) {
				return a.top - b.top;
			});
		};

		return Scrollspy;
	}(_metalState2.default);

	Scrollspy.STATE = {
		/**
   * Class to be used as active class.
   * @type {string}
   */
		activeClass: {
			validator: _metal2.default.isString,
			value: 'active'
		},

		/**
   * The index of the currently active link.
   * @type {number}
   */
		activeIndex: {
			validator: _metal2.default.isNumber,
			value: -1
		},

		/**
   * Function that receives the matching element as argument and return
   * itself. Relevant when the `activeClass` must be applied to a different
   * element, e.g. a parentNode.
   * @type {function}
   * @default core.identityFunction
   */
		resolveElement: {
			validator: _metal2.default.isFunction,
			value: _metal2.default.identityFunction
		},

		/**
   * The scrollElement element to be used as scrollElement area for scrollspy.
   * The scrollElement is where the scroll event is listened from.
   * @type {Element|Window}
   */
		scrollElement: {
			setter: _metalDom2.default.toElement,
			value: document
		},

		/**
   * Defines the offset that triggers scrollspy.
   * @type {number}
   * @default 0
   */
		offset: {
			validator: _metal2.default.isNumber,
			value: 0
		},

		/**
   * Element to be used as alignment reference of scrollspy.
   * @type {Element}
   */
		element: {
			setter: _metalDom2.default.toElement
		},

		/**
   * Selector to query elements inside `element` to be activated.
   * @type {Element}
   * @default 'a'
   */
		selector: {
			validator: _metal2.default.isString,
			value: 'a'
		}
	};

	exports.default = Scrollspy;
});
//# sourceMappingURL=Scrollspy.js.map