'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-router@3.6.3/lib/Router", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-spa-web$senna', 'frontend-js-metal-web$metal-promise', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-incremental-dom', 'frontend-js-metal-web$metal-uri'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _get = function get(object, property, receiver) {
		if (object === null) object = Function.prototype;var desc = Object.getOwnPropertyDescriptor(object, property);if (desc === undefined) {
			var parent = Object.getPrototypeOf(object);if (parent === null) {
				return undefined;
			} else {
				return get(parent, property, receiver);
			}
		} else if ("value" in desc) {
			return desc.value;
		} else {
			var getter = desc.get;if (getter === undefined) {
				return undefined;
			}return getter.call(receiver);
		}
	};

	var _metal = require("frontend-js-metal-web$metal");

	var _senna = require("frontend-js-spa-web$senna");

	var _metalPromise = require("frontend-js-metal-web$metal-promise");

	var _metalPromise2 = _interopRequireDefault(_metalPromise);

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalIncrementalDom = require("frontend-js-metal-web$metal-incremental-dom");

	var _metalIncrementalDom2 = _interopRequireDefault(_metalIncrementalDom);

	var _metalUri = require("frontend-js-metal-web$metal-uri");

	var _metalUri2 = _interopRequireDefault(_metalUri);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
		if (Array.isArray(arr)) {
			for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
				arr2[i] = arr[i];
			}return arr2;
		} else {
			return Array.from(arr);
		}
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * Router class responsible for routing links to components.
  */
	var Router = function (_Component) {
		_inherits(Router, _Component);

		function Router() {
			_classCallCheck(this, Router);

			return _possibleConstructorReturn(this, (Router.__proto__ || Object.getPrototypeOf(Router)).apply(this, arguments));
		}

		_createClass(Router, [{
			key: 'created',

			/**
    * @inheritDoc
    */
			value: function created() {
				this.route = new _senna.Route(this.path, this.createScreen_.bind(this));
				this.route.router = this;
				Router.router().addRoutes(this.route);

				// Router is never active on the first render, since it needs to wait for
				// any async data to load first. This code is to make sure it won't lose
				// the reference to its `element` and cause it to be removed from the dom
				// (which would be bad for progressive enhancement) due to not rendering
				// anything. It will be set back in `attached`.
				this.firstRenderElement = this.element;
				this.element = null;
			}

			/**
    * Adds routing data to the given state object.
    * @param {string} path
    * @param {!Object} state
    * @return {!Object}
    */

		}, {
			key: 'addRoutingData',
			value: function addRoutingData(path, state) {
				if (this.includeRoutingData) {
					var params = this.lastExtractedParams || this.extractParams(path);
					var query = this.extractQuery(path);
					return _metal.object.mixin({}, state, {
						router: {
							currentUrl: path,
							params: params,
							query: query
						}
					});
				}
				return state;
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'attached',
			value: function attached() {
				if (!this.wasRendered) {
					this.element = this.firstRenderElement;
				}
			}

			/**
    * Creates the screen to be used by this router.
    * @protected
    */

		}, {
			key: 'createScreen_',
			value: function createScreen_() {
				this.screen_ = new Router.defaultScreen(this);
				return this.screen_;
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'disposeInternal',
			value: function disposeInternal() {
				if (Router.activeRouter === this) {
					Router.activeRouter = null;
				}
				Router.router().removeRoute(this.route);
				_get(Router.prototype.__proto__ || Object.getPrototypeOf(Router.prototype), 'disposeInternal', this).call(this);
			}

			/**
    * Extracts any params present in the given path.
    * @param {string} path
    * @return {Object}
    */

		}, {
			key: 'extractParams',
			value: function extractParams(path) {
				return Router.router().extractParams(this.route, path);
			}

			/**
    * Extracts any query params present in the given path.
    * @param {string} path
    * @return {Object}
    */

		}, {
			key: 'extractQuery',
			value: function extractQuery(path) {
				var uri = new _metalUri2.default(path);
				var queryStrings = {};

				var parameterNames = uri.getParameterNames();

				for (var i = 0; i < parameterNames.length; i++) {
					var name = parameterNames[i];

					queryStrings[name] = uri.getParameterValue(name);
				}

				return queryStrings;
			}

			/**
    * Gets the currently active component from the current router.
    * @return {Component}
    */

		}, {
			key: 'getRouteComponent',

			/**
    * Gets this router's component, if there is one.
    * @return {Component}
    */
			value: function getRouteComponent() {
				return this.components.comp;
			}

			/**
    * Gets the screen that is being used by this router.
    */

		}, {
			key: 'getScreen',
			value: function getScreen() {
				return this.screen_;
			}

			/**
    * Renders the component, if the current path is active, or nothing otherwise.
    */

		}, {
			key: 'render',
			value: function render() {
				if (this.isActive_) {
					var _IncrementalDOM;

					(_IncrementalDOM = IncrementalDOM).elementVoid.apply(_IncrementalDOM, [this.component, null, null, 'ref', 'comp'].concat(_toConsumableArray(this.toArray_(Router.activeState))));
				}
			}

			/**
    * Returns the single Senna.js application that handles all `Router`
    * instances, creating it if it hasn't been built yet.
    * @return {!App}
    * @static
    */

		}, {
			key: 'setterComponentFn_',

			/**
    * Setter for the "component" state property.
    * @param {!Function|string} ctor
    * @return {!Function}
    * @protected
    */
			value: function setterComponentFn_(ctor) {
				if (_metal.core.isString(ctor)) {
					ctor = _metalComponent.ComponentRegistry.getConstructor(ctor);
				}
				return ctor;
			}

			/**
    * Makes sure that the `Router` is only rerendered if either `isActive_` or
    * `component` has changed. The other state properties are not used for
    * rendering.
    */

		}, {
			key: 'shouldUpdate',
			value: function shouldUpdate(changes) {
				return changes.isActive_ || changes.component;
			}

			/**
    * Converts the given object into an array to be passed to an incremental dom
    * call.
    * @param {!Object} config
    * @return {!Array}
    * @protected
    */

		}, {
			key: 'toArray_',
			value: function toArray_(config) {
				var arr = [];
				var keys = Object.keys(config || {});
				for (var i = 0; i < keys.length; i++) {
					arr.push(keys[i], config[keys[i]]);
				}
				return arr;
			}
		}], [{
			key: 'getActiveComponent',
			value: function getActiveComponent() {
				return Router.activeRouter ? Router.activeRouter.getRouteComponent() : null;
			}

			/**
    * Gets the state for the currently active component.
    * @return {Object}
    */

		}, {
			key: 'getActiveState',
			value: function getActiveState() {
				return Router.activeState;
			}
		}, {
			key: 'router',
			value: function router() {
				if (!Router.routerInstance) {
					var app = new _senna.App();
					app.setIgnoreQueryStringFromRoutePath(true);
					Router.routerInstance = app;
				}
				return Router.routerInstance;
			}
		}]);

		return Router;
	}(_metalComponent.Component);

	Router.RENDERER = _metalIncrementalDom2.default;

	/**
  * Router state definition.
  * @type {!Object}
  * @static
  */
	Router.STATE = {
		/**
   * Handler to be called before a router is deactivated. Can be given as a
   * function reference directly, or as the name of a function to be called in
   * the router's component instance.
   * @type {!function()|string}
   */
		beforeDeactivateHandler: {
			validator: function validator(val) {
				return _metal.core.isString(val) || _metal.core.isFunction(val);
			}
		},

		/**
   * If set to true navigation will cache component state deferred results.
   * @type {boolean}
   * @default true
   */
		cacheable: {
			validator: _metal.core.isBoolean,
			value: true
		},

		/**
   * The constructor of the component to render when path is accessed.
   * @type {!Function|string}
   */
		component: {
			setter: 'setterComponentFn_'
		},

		/**
   * Holds the load data value, function or deferred function that
   * resolves the component configurations.
   * @type {!Object|function(?string=)}
   */
		data: {
			setter: function setter(val) {
				return _metal.core.isFunction(val) ? val : function () {
					return val || {};
				};
			}
		},

		/**
   * Flag indicating if the component's data should be loaded via a request
   * to the server. By default the data will come from `data` instead.
   */
		fetch: {
			value: false
		},

		/**
   * Url to be used when fetching data for this route. If nothing is given,
   * the current path will be used by default. Note that this is only relevant
   * if "fetch" is set to `true`.
   * @type {?string|function()}
   */
		fetchUrl: {
			validator: function validator(val) {
				return _metal.core.isString(val) || _metal.core.isFunction(val);
			}
		},

		/**
   * The timeout in ms used by `Router.defaultScreen` in ajax requests for
   * fetching data.
   * @type {?number}
   */
		fetchTimeout: {
			validator: function validator(val) {
				return _metal.core.isNumber(val) || !_metal.core.isDefAndNotNull(val);
			},
			value: 30000
		},

		/**
   * Flag indicating if routing data (such as the current url) should be
   * included in the component's data.
   */
		includeRoutingData: {
			value: true
		},

		/**
   * Internal flag indicating if the router's path is currently active.
   * @type {boolean}
   */
		isActive_: {
			internal: true,
			value: false
		},

		/**
   * Defines the path which will trigger the route handler responsible for
   * rendering the metal component.
   * @type {!string|RegExp|Function}
   */
		path: {}
	};

	/**
  * Holds the active router.
  * @type {Router}
  * @static
  */
	Router.activeRouter = null;

	/**
  * Holds the active render state.
  * @type {*}
  * @static
  */
	Router.activeState = null;

	var ComponentScreen = function (_RequestScreen) {
		_inherits(ComponentScreen, _RequestScreen);

		/**
   * @inheritDoc
   */
		function ComponentScreen(router) {
			_classCallCheck(this, ComponentScreen);

			var _this2 = _possibleConstructorReturn(this, (ComponentScreen.__proto__ || Object.getPrototypeOf(ComponentScreen)).call(this));

			if (!router) {
				throw new Error('Router not specified for component screen.');
			}

			/**
    * Router responsible for the screen.
    * @type {Router}
    */
			_this2.router = router;

			// Sets the timeout used by `RequestScreen` to be the one specified by
			// the router.
			_this2.timeout = router.fetchTimeout;
			return _this2;
		}

		/**
   * Calls the handler specified by the router's `beforeDeactivateHandler`
   * state property.
   * @return {?boolean}
   */

		_createClass(ComponentScreen, [{
			key: 'beforeDeactivate',
			value: function beforeDeactivate() {
				var handler = this.router.beforeDeactivateHandler;
				if (handler) {
					if (_metal.core.isString(handler)) {
						var comp = this.router.getRouteComponent();
						if (comp && _metal.core.isFunction(comp[handler])) {
							return comp[handler]();
						} else {
							var compName = (0, _metal.getFunctionName)(comp);
							throw new Error('No function named "' + handler + '" exists inside ' + compName + '.');
						}
					} else {
						return handler();
					}
				}
			}

			/**
    * Returns the path that should be used to update navigation history. When
    * `fetchUrl` is given we should make sure that the original path is used
    * instead of the request one.
    * @param {string}
    */

		}, {
			key: 'beforeUpdateHistoryPath',
			value: function beforeUpdateHistoryPath(path) {
				return this.router.fetchUrl ? path : _get(ComponentScreen.prototype.__proto__ || Object.getPrototypeOf(ComponentScreen.prototype), 'beforeUpdateHistoryPath', this).call(this, path);
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'evaluateScripts',
			value: function evaluateScripts() {}

			/**
    * @inheritDoc
    */

		}, {
			key: 'evaluateStyles',
			value: function evaluateStyles() {}

			/**
    * @inheritDoc
    */

		}, {
			key: 'flip',
			value: function flip() {
				this.maybeRedirectRouter();

				Router.activeState = this.router.addRoutingData(this.router.lastPath, this.maybeParseLastLoadedStateAsJson());

				if (Router.activeRouter) {
					Router.activeRouter.isActive_ = false;
					this.reuseActiveRouterElementInNewRouter_(this.router);
				}

				var deferred = this.waitRouterRenderSubComponents(this.router);
				Router.activeRouter = this.router;
				Router.activeRouter.isActive_ = true;
				return deferred;
			}

			/**
    * Gets the url that should be used to fetch data.
    * @param {string} path
    * @return {string}
    * @protected
    */

		}, {
			key: 'getFetchUrl_',
			value: function getFetchUrl_(path) {
				var fetchPath = this.router.fetchUrl || path;
				if (_metal.core.isFunction(fetchPath)) {
					fetchPath = fetchPath(path);
				}
				return fetchPath;
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'load',
			value: function load(path) {
				var _this3 = this;

				this.setCacheable(this.router.cacheable);
				var deferred = _metalPromise2.default.resolve();
				var params = void 0;
				if (this.router.fetch) {
					deferred = deferred.then(function () {
						return _get(ComponentScreen.prototype.__proto__ || Object.getPrototypeOf(ComponentScreen.prototype), 'load', _this3).call(_this3, _this3.getFetchUrl_(path));
					});
				} else {
					params = this.router.extractParams(path);
					deferred = deferred.then(function () {
						return _this3.router.data(path, params);
					});
				}
				return deferred.then(function (loadedState) {
					_this3.router.lastPath = path;
					_this3.router.lastRedirectPath = _this3.maybeFindRedirectPath();
					_this3.router.lastLoadedState = loadedState;
					_this3.router.lastExtractedParams = params;
					return loadedState;
				});
			}

			/**
    * Some responses made by superclass performs a 302 redirect which will be
    * reflected into the browser history path. When redirected, make sure to
    * render the best component match to new path.
    * @return {?String} Redirect path.
    */

		}, {
			key: 'maybeFindRedirectPath',
			value: function maybeFindRedirectPath() {
				var redirectPath = this.beforeUpdateHistoryPath(this.router.lastPath);
				if (redirectPath !== this.router.lastPath) {
					return redirectPath;
				}
				return null;
			}

			/**
    * Some responses made by superclass performs a 302 redirect which will be
    * reflected into the browser history path. When redirected, make sure to
    * render the best component match to new path. If not found any, it will
    * use current router component.
    * @return {Router}
    */

		}, {
			key: 'maybeFindRedirectRouter',
			value: function maybeFindRedirectRouter() {
				var redirectPath = this.maybeFindRedirectPath();
				if (redirectPath) {
					var redirectRoute = Router.router().findRoute(redirectPath);
					if (redirectRoute) {
						// The initiator component will load the render state and follow any
						// "302" redirect that may happen. Therefore, the data returned of the
						// redirect is used as "lastLoadedState" and the "lastRedirectPath" as
						// "lastPath" for redirect router.
						redirectRoute.router.lastPath = this.router.lastRedirectPath;
						redirectRoute.router.lastLoadedState = this.router.lastLoadedState;
						return redirectRoute.router;
					}
				}
				return null;
			}

			/**
    * Maybe parses last state as Json, if not able to parse an object is
    * returned.
    * @return {object}
    */

		}, {
			key: 'maybeParseLastLoadedStateAsJson',
			value: function maybeParseLastLoadedStateAsJson() {
				var state = this.router.lastLoadedState;
				try {
					return JSON.parse(state);
				} catch (err) {
					return _metal.core.isDefAndNotNull(state) ? state : {};
				}
			}

			/**
    * @protected
    */

		}, {
			key: 'maybeRedirectRouter',
			value: function maybeRedirectRouter() {
				var redirectRouter = this.maybeFindRedirectRouter();
				if (redirectRouter) {
					// If performing a redirect use "redirectRouter" as "this.router". The
					// initiator "this.router" is completely ignored from now on.
					this.router = redirectRouter;

					// Schedule screen cache redirect on "endNavigate".
					var app = Router.router();
					app.once('endNavigate', function () {
						app.screens[app.redirectPath] = app.screens[app.activePath];
						delete app.screens[app.activePath];
					});
				}
			}

			/**
    * If the routers were attached to the same element when created, then they
    * should reuse the same element when active, so we can guarantee that they
    * will be positioned correctly.
    * @param {Router} router The new router.
    * @protected
    */

		}, {
			key: 'reuseActiveRouterElementInNewRouter_',
			value: function reuseActiveRouterElementInNewRouter_(router) {
				var activeRouter = Router.activeRouter;
				if (activeRouter !== router) {
					if (activeRouter.firstRenderElement === router.firstRenderElement) {
						router.element = activeRouter.element;
						activeRouter.element = null;
					}
				}
			}

			/**
    * @param {Router} router
    * @return {Promise}
    * @protected
    */

		}, {
			key: 'waitRouterRenderSubComponents',
			value: function waitRouterRenderSubComponents(router) {
				return new Promise(function (res) {
					return router.once('rendered', res);
				});
			}
		}]);

		return ComponentScreen;
	}(_senna.RequestScreen);

	/**
  * Default screen used for handling components.
  * @type {ComponentScreen}
  */

	Router.defaultScreen = ComponentScreen;

	exports.default = Router;
});
//# sourceMappingURL=Router.js.map