'use strict';

Liferay.Loader.define("frontend-js-metal-web$metal-jsx@2.16.5/lib/JSXDataManager", ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-state'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	var _metal = require("frontend-js-metal-web$metal");

	var _metalComponent = require("frontend-js-metal-web$metal-component");

	var _metalState = require("frontend-js-metal-web$metal-state");

	var _metalState2 = _interopRequireDefault(_metalState);

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	function _possibleConstructorReturn(self, call) {
		if (!self) {
			throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
		}return call && (typeof call === "object" || typeof call === "function") ? call : self;
	}

	function _inherits(subClass, superClass) {
		if (typeof superClass !== "function" && superClass !== null) {
			throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
		}subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } });if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
	}

	/**
  * DataManager for JSX
  */
	var JSXDataManager = function (_ComponentDataManager) {
		_inherits(JSXDataManager, _ComponentDataManager);

		function JSXDataManager() {
			_classCallCheck(this, JSXDataManager);

			return _possibleConstructorReturn(this, (JSXDataManager.__proto__ || Object.getPrototypeOf(JSXDataManager)).apply(this, arguments));
		}

		_createClass(JSXDataManager, [{
			key: 'addUnconfiguredProps_',

			/**
    * Manually adds props that weren't configured via `PROPS`.
    * @param {!Component} component
    * @param {!State} props
    * @param {!Object} data
    * @protected
    */
			value: function addUnconfiguredProps_(component, props, data) {
				var keys = Object.keys(data);
				for (var i = 0; i < keys.length; i++) {
					if (!props.hasStateKey(keys[i])) {
						component.props[keys[i]] = data[keys[i]];
					}
				}
			}

			/**
    * Overrides the original method so that we can have two separate `State`
    * instances: one responsible for `state` and another for `props`.
    * @param {!Component} comp
    * @param {!Object} config
    * @protected
    * @override
    */

		}, {
			key: 'createState_',
			value: function createState_(comp, config) {
				var ctor = comp.constructor;
				comp.props = {};
				comp.state = {};
				var data = this.getManagerData(comp);

				data.props_ = new _metalState2.default(comp.getInitialConfig(), comp.props, comp);
				data.props_.configState(_metal.object.mixin({}, config, (0, _metal.getStaticProperty)(ctor, 'PROPS', _metalState2.default.mergeState)));
				this.addUnconfiguredProps_(comp, data.props_, comp.getInitialConfig());

				data.state_ = new _metalState2.default({}, comp.state, comp);
				data.state_.setEventData({
					type: 'state'
				});
				data.state_.configState(_metalState2.default.getStateStatic(ctor));
			}

			/**
    * @inheritDoc
    */

		}, {
			key: 'dispose',
			value: function dispose(component) {
				var data = this.getManagerData(component);
				data.props_.dispose();
				_metalComponent.ComponentDataManager.dispose.call(this, component);
			}

			/**
    * Overrides the original method so we can get properties from `props` by
    * default.
    * @param {!Component} component
    * @param {string} name
    * @return {*}
    * @override
    */

		}, {
			key: 'get',
			value: function get(component, name) {
				return this.getManagerData(component).props_.get(name);
			}

			/**
    * Gets the `State` instance being used for "props".
    * @param {!Component} component
    * @return {!Object}
    */

		}, {
			key: 'getPropsInstance',
			value: function getPropsInstance(component) {
				return this.getManagerData(component).props_;
			}

			/**
    * Overrides the original method so we can enable "sync" methods just for
    * `props`.
    * @param {!Component} component
    * @return {!Array<string>}
    * @override
    */

		}, {
			key: 'getSyncKeys',
			value: function getSyncKeys(component) {
				return this.getManagerData(component).props_.getStateKeys();
			}

			/**
    * Overrides the original method so we can replace values in `props`.
    * @param {!Component} component
    * @param {!Object} data
    * @override
    */

		}, {
			key: 'replaceNonInternal',
			value: function replaceNonInternal(component, data) {
				var prevProps = void 0;
				if (component.propsChanged) {
					prevProps = _metal.object.mixin({}, component.props);
				}

				var props = this.getManagerData(component).props_;
				_metalComponent.ComponentDataManager.replaceNonInternal.call(this, component, data, props); // eslint-disable-line
				this.addUnconfiguredProps_(component, props, data);
				if (component.propsChanged) {
					component.propsChanged(prevProps);
				}
			}
		}]);

		return JSXDataManager;
	}(_metalComponent.ComponentDataManager.constructor);

	exports.default = new JSXDataManager();
});
//# sourceMappingURL=JSXDataManager.js.map