'use strict';

/**
 * Base class that component renderers should extend from. It defines the
 * required methods all renderers should have.
 */

Liferay.Loader.define("frontend-js-metal-web$metal-component@2.16.5/lib/ComponentRenderer", ['module', 'exports', 'require'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _createClass = function () {
		function defineProperties(target, props) {
			for (var i = 0; i < props.length; i++) {
				var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
			}
		}return function (Constructor, protoProps, staticProps) {
			if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
		};
	}();

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var ComponentRenderer = function () {
		function ComponentRenderer() {
			_classCallCheck(this, ComponentRenderer);
		}

		_createClass(ComponentRenderer, [{
			key: 'dispose',

			/**
    * Disposes of any data specific to the given component.
    * @param {!Component} component
    */
			value: function dispose() {}

			/**
    * Returns extra configuration for data that should be added to the manager.
    * Sub classes can override to return `State` config for properties that
    * should be added to the component.
    * @param {!Component} component
    */

		}, {
			key: 'getExtraDataConfig',
			value: function getExtraDataConfig() {}

			/**
    * Renders the whole content (including its main element) and informs the
    * component about it. Should be overridden by sub classes.
    * @param {!Component} component
    */

		}, {
			key: 'render',
			value: function render(component) {
				if (!component.element) {
					component.element = document.createElement('div');
				}
				component.informRendered();
			}

			/**
    * Sets up this component to be used by this renderer. Sub classes should
    * override as needed for more behavior.
    * @param {!Component} component
    */

		}, {
			key: 'setUp',
			value: function setUp() {}

			/**
    * Updates the component's element html. This is automatically called when
    * the value of at least one of the component's state keys has changed.
    * Should be implemented by sub classes. Sub classes have to remember to call
    * "informRendered" on the component when any update rendering is done.
    * @param {!Component} component
    * @param {Object.<string, Object>} changes Object containing the names
    *     of all changed state keys, each mapped to an object with its new
    *     (newVal) and previous (prevVal) values.
    */

		}, {
			key: 'update',
			value: function update() {}
		}]);

		return ComponentRenderer;
	}();

	exports.default = new ComponentRenderer();
});
//# sourceMappingURL=ComponentRenderer.js.map