'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-assertions@2.16.5/lib/assertions', ['module', 'exports', 'require', 'frontend-js-metal-web$metal'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.assertBoolean = assertBoolean;
  exports.assertDef = assertDef;
  exports.assertDefAndNotNull = assertDefAndNotNull;
  exports.assertFunction = assertFunction;
  exports.assertNotNull = assertNotNull;
  exports.assertNumber = assertNumber;
  exports.assertObject = assertObject;
  exports.assertString = assertString;
  exports.assertDocument = assertDocument;
  exports.assertDocumentFragment = assertDocumentFragment;
  exports.assertElement = assertElement;
  exports.assertWindow = assertWindow;

  var _metal = require('frontend-js-metal-web$metal');

  /**
   * Asserts value is a boolean.
   * @param  {*} value
   * @param  {string} errorMessage Error message
   */
  function assertBoolean(value, errorMessage) {
    if (!(0, _metal.isBoolean)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is defined.
   * @param  {Object} value
   * @param  {string} errorMessage Error message
   */
  function assertDef(value, errorMessage) {
    if (!(0, _metal.isDef)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is defined and not null.
   * @param  {Object} value
   * @param  {string} errorMessage Error message
   */
  function assertDefAndNotNull(value, errorMessage) {
    if (!(0, _metal.isDefAndNotNull)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is a function.
   * @param  {Function} value
   * @param  {string} errorMessage Error message
   */
  function assertFunction(value, errorMessage) {
    if (!(0, _metal.isFunction)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is not null.
   * @param  {Object} value
   * @param  {string} errorMessage Error message
   */
  function assertNotNull(value, errorMessage) {
    if ((0, _metal.isNull)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is a number.
   * @param  {Number} value
   * @param  {string} errorMessage Error message
   */
  function assertNumber(value, errorMessage) {
    if (!(0, _metal.isNumber)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is an object.
   * @param  {Object} value
   * @param  {string} errorMessage Error message
   */
  function assertObject(value, errorMessage) {
    if (!(0, _metal.isObject)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is a string.
   * @param  {String} value
   * @param  {string} errorMessage Error message
   */
  function assertString(value, errorMessage) {
    if (!(0, _metal.isString)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is a document.
   * @param  {Document} value
   * @param  {string} errorMessage Error message
   */
  function assertDocument(value, errorMessage) {
    if (!(0, _metal.isDocument)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is a document fragment.
   * @param  {DocumentFragment} value
   * @param  {string} errorMessage Error message
   */
  function assertDocumentFragment(value, errorMessage) {
    if (!(0, _metal.isDocumentFragment)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is an element.
   * @param  {Element} value
   * @param  {string} errorMessage Error message
   */
  function assertElement(value, errorMessage) {
    if (!(0, _metal.isElement)(value)) {
      throw new Error(errorMessage);
    }
  }

  /**
   * Asserts value is a window.
   * @param  {Window} value
   * @param  {string} errorMessage Error message
   */
  function assertWindow(value, errorMessage) {
    if (!(0, _metal.isWindow)(value)) {
      throw new Error(errorMessage);
    }
  }
});
//# sourceMappingURL=assertions.js.map