'use strict';

Liferay.Loader.define('frontend-js-metal-web$metal-anim@2.0.0/lib/Anim', ['module', 'exports', 'require', 'frontend-js-metal-web$metal', 'frontend-js-metal-web$metal-dom'], function (module, exports, require) {
	var define = undefined;
	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _metal = require('frontend-js-metal-web$metal');

	var _metal2 = _interopRequireDefault(_metal);

	var _metalDom = require('frontend-js-metal-web$metal-dom');

	function _interopRequireDefault(obj) {
		return obj && obj.__esModule ? obj : { default: obj };
	}

	function _classCallCheck(instance, Constructor) {
		if (!(instance instanceof Constructor)) {
			throw new TypeError("Cannot call a class as a function");
		}
	}

	var Anim = function () {
		function Anim() {
			_classCallCheck(this, Anim);
		}

		/**
   * Emulates animation or transition end event, the end event with longer
   * duration will be used by the emulation. If they have the same value,
   * transitionend will be emulated.
   * @param {!Element} element
   * @param {number=} opt_durationMs
   * @return {!Object} Object containing `abort` function.
   */
		Anim.emulateEnd = function emulateEnd(element, opt_durationMs) {
			if (this.getComputedDurationMs(element, 'animation') > this.getComputedDurationMs(element, 'transition')) {
				return this.emulateEnd_(element, 'animation', opt_durationMs);
			} else {
				return this.emulateEnd_(element, 'transition', opt_durationMs);
			}
		};

		/**
   * Emulates animation end event. If `opt_durationMs` not specified the value
   * will read from computed style for animation-duration.
   * @param {!Element} element
   * @param {number=} opt_durationMs
   * @return {!Object} Object containing `abort` function.
   */

		Anim.emulateAnimationEnd = function emulateAnimationEnd(element, opt_durationMs) {
			return this.emulateEnd_(element, 'animation', opt_durationMs);
		};

		/**
   * Emulates transition end event. If `opt_durationMs` not specified the
   * value will read from computed style for transition-duration.
   * @param {!Element} element
   * @param {number=} opt_durationMs
   * @return {!Object} Object containing `abort` function.
   */

		Anim.emulateTransitionEnd = function emulateTransitionEnd(element, opt_durationMs) {
			this.emulateEnd_(element, 'transition', opt_durationMs);
		};

		/**
   * Emulates transition or animation end.
   * @param {!Element} element
   * @param {string} type
   * @param {number=} opt_durationMs
   * @return {!Object} Object containing `abort` function.
   * @protected
   */

		Anim.emulateEnd_ = function emulateEnd_(element, type, opt_durationMs) {
			var duration = opt_durationMs;
			if (!_metal2.default.isDef(opt_durationMs)) {
				duration = this.getComputedDurationMs(element, type);
			}

			var delayed = setTimeout(function () {
				_metalDom.dom.triggerEvent(element, _metalDom.features.checkAnimationEventName()[type]);
			}, duration);

			var abort = function abort() {
				clearTimeout(delayed);
				hoistedEvtHandler.removeListener();
			};
			var hoistedEvtHandler = _metalDom.dom.once(element, type + 'end', abort);

			return {
				abort: abort
			};
		};

		/**
   * Gets computed style duration for duration.
   * @param {!Element} element
   * @param {string} type
   * @return {number} The computed duration in milliseconds.
   */

		Anim.getComputedDurationMs = function getComputedDurationMs(element, type) {
			return (parseFloat(window.getComputedStyle(element, null).getPropertyValue(type + '-duration')) || 0) * 1000;
		};

		return Anim;
	}();

	exports.default = Anim;
});
//# sourceMappingURL=Anim.js.map